/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.noderunner.http.HttpException;

public class HttpVersion {
    private final int major;
    private final int minor;
    private final String toString;
    public static final HttpVersion HTTP11 = new HttpVersion(1, 1);
    public static final HttpVersion HTTP10 = new HttpVersion(1, 0);
    public static final String HTTP_VERSION_BEGIN = "HTTP/";

    public HttpVersion(String line) throws HttpException {
        if (line == null) {
            throw new IllegalArgumentException("Null HTTP version line");
        }
        if (!line.startsWith(HTTP_VERSION_BEGIN)) {
            throw new HttpException("HTTP Version prefix invalid: " + line);
        }
        StringTokenizer st = new StringTokenizer(line, "/.");
        try {
            st.nextToken();
            this.major = Integer.parseInt(st.nextToken());
            this.minor = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new HttpException("HTTP version invalid syntax");
        }
        catch (NumberFormatException e) {
            throw new HttpException("HTTP version invalid number");
        }
        this.toString = HTTP_VERSION_BEGIN + this.getMajorVersion() + '.' + this.getMinorVersion();
    }

    public static HttpVersion parseVersion(String version) throws HttpException {
        if (version.equals(HTTP10.toString())) {
            return HTTP10;
        }
        if (version.equals(HTTP11.toString())) {
            return HTTP11;
        }
        return new HttpVersion(version);
    }

    public HttpVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.toString = HTTP_VERSION_BEGIN + this.getMinorVersion() + '.' + this.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpVersion)) {
            return false;
        }
        HttpVersion v = (HttpVersion)other;
        return v.getMinorVersion() == this.getMinorVersion() && v.getMajorVersion() == this.getMajorVersion();
    }

    public int hashCode() {
        return this.major * 10 + this.minor;
    }
}

