/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.noderunner.http.HttpException;
import net.noderunner.http.HttpVersion;

public class StatusLine {
    public static final StatusLine HTTP11_100 = new StatusLine(HttpVersion.HTTP11, 100, "Continue");
    public static final StatusLine HTTP11_200_OK = new StatusLine(HttpVersion.HTTP11, 200, "OK");
    public static final StatusLine HTTP11_204 = new StatusLine(HttpVersion.HTTP11, 204, "No Content");
    public static final StatusLine HTTP11_301 = new StatusLine(HttpVersion.HTTP11, 301, "Moved Permanently");
    public static final StatusLine HTTP11_404 = new StatusLine(HttpVersion.HTTP11, 404, "Not Found");
    private final HttpVersion version;
    private final int statusCode;
    private final String reasonPhrase;
    private String toString;

    public StatusLine(int statusCode) {
        this(HttpVersion.HTTP11, statusCode, "");
    }

    public StatusLine(HttpVersion version, int statusCode, String reasonPhrase) {
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("Null reason");
        }
        if (statusCode < 0 || statusCode > 999) {
            throw new IllegalArgumentException("Invalid range for status code");
        }
        this.version = version;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public StatusLine(String line) throws HttpException {
        if (line == null) {
            throw new IllegalArgumentException("Null status line");
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        try {
            this.version = HttpVersion.parseVersion(st.nextToken());
            this.statusCode = Integer.parseInt(st.nextToken());
            if (this.statusCode < 0 || this.statusCode > 999) {
                throw new HttpException("Invalid status number: " + this.statusCode);
            }
            this.reasonPhrase = st.nextToken("").trim();
        }
        catch (NoSuchElementException e) {
            throw new HttpException("Invalid status line: " + line);
        }
    }

    public StatusLine(int statusCode, String statusReason) {
        this(HttpVersion.HTTP11, statusCode, statusReason);
    }

    public static StatusLine parseStatusLine(String line) throws HttpException {
        if (line == null) {
            throw new IllegalArgumentException("Null status line");
        }
        if (line.equals(HTTP11_200_OK.toString())) {
            return HTTP11_200_OK;
        }
        return new StatusLine(line);
    }

    public HttpVersion getHttpVersion() {
        return this.version;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getHttpVersion().toString() + ' ' + this.getStatusCode() + ' ' + this.getReasonPhrase();
        }
        return this.toString;
    }
}

