/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.noderunner.http.BasicHttpServer;
import net.noderunner.http.HttpServer;

public abstract class ThreadedHttpServer
implements Runnable {
    protected final ServerSocket ss;
    private Thread t;
    private volatile boolean run = true;

    public ThreadedHttpServer(ServerSocket ss) {
        this.ss = ss;
    }

    public ThreadedHttpServer() throws IOException {
        this.ss = new ServerSocket(0);
    }

    public void start() {
        this.t = new Thread(this);
        this.t.setName("listen-" + this.ss.getLocalSocketAddress());
        this.t.setDaemon(true);
        this.t.start();
    }

    public int getPort() {
        return this.ss.getLocalPort();
    }

    protected abstract void handleRequest(Request var1) throws IOException;

    protected void exception(Exception e) {
    }

    public final void run() {
        while (this.run) {
            Socket socket = null;
            try {
                socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                new SocketHandler(socket).start();
            }
            catch (IOException e) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!this.run) continue;
                this.exception(e);
            }
        }
    }

    public void close() throws IOException {
        this.run = false;
        if (this.ss != null) {
            this.ss.close();
        }
        if (this.t == null) {
            return;
        }
        this.t.interrupt();
        try {
            this.t.join();
        }
        catch (InterruptedException e) {
            this.exception(e);
            Thread.currentThread().interrupt();
        }
    }

    void interrupt() throws IOException {
        this.t.interrupt();
    }

    public String toString() {
        return "SingleHttpServer ss=" + this.ss;
    }

    private class SocketHandler
    extends Thread {
        private Socket socket;

        public SocketHandler(Socket socket) {
            this.socket = socket;
            this.setName("handle-" + socket.getInetAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                try {
                    BasicHttpServer server = new BasicHttpServer(this.socket);
                    while (true) {
                        Request request = new Request(server, (InetSocketAddress)this.socket.getRemoteSocketAddress());
                        ThreadedHttpServer.this.handleRequest(request);
                    }
                }
                catch (IOException e) {
                    ThreadedHttpServer.this.exception(e);
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        ThreadedHttpServer.this.exception(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    ThreadedHttpServer.this.exception(e);
                }
                throw throwable;
            }
        }
    }

    public class Request {
        private HttpServer server;
        private InetSocketAddress address;

        public Request(HttpServer server, InetSocketAddress address) {
            this.server = server;
            this.address = address;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.address;
        }

        public HttpServer getServer() {
            return this.server;
        }
    }
}

