/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import net.noderunner.http.ServerRequest;
import net.noderunner.http.ServerResponse;
import net.noderunner.http.ThreadedHttpServer;
import net.noderunner.http.servlet.HttpServletRequestImpl;
import net.noderunner.http.servlet.HttpServletResponseImpl;

public class ServletServer
extends ThreadedHttpServer {
    private final HttpServlet servlet;

    public ServletServer(HttpServlet servlet) throws IOException {
        this.servlet = servlet;
    }

    public ServletServer(HttpServlet servlet, ServerSocket ss) {
        super(ss);
        this.servlet = servlet;
    }

    public ServletServer(HttpServlet servlet, int port) throws IOException {
        this(servlet, new ServerSocket(port));
    }

    protected void handleRequest(ThreadedHttpServer.Request r) throws IOException {
        ServerRequest request = r.getServer().readRequest();
        HttpServletRequestImpl sreq = new HttpServletRequestImpl(request);
        HttpServletResponseImpl sres = new HttpServletResponseImpl();
        sres.setHeader("server", "ServletServer_" + this.servlet.getClass().getSimpleName());
        if (this.ss != null) {
            sreq.serverSocket(this.ss);
        }
        sreq.remoteAddress(r.getRemoteAddress());
        try {
            this.servlet.service((ServletRequest)sreq, (ServletResponse)sres);
        }
        catch (Exception e) {
            PrintWriter pw = sres.getWriter();
            pw.println("Failure to process request:");
            e.printStackTrace(pw);
            pw.flush();
            sres.setStatus(500, sres.toString());
            this.exception(e);
        }
        ServerResponse response = sres.createServerResponse();
        r.getServer().writeResponse(response);
    }
}

