/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.util.Date;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;

public class SimpleOAuthValidator
implements OAuthValidator {
    private static final long defaultTimestampWindow = 300000L;
    private final long timestampWindow;
    private final double maxVersion;
    private Env env = new Env();

    public SimpleOAuthValidator() {
        this(300000L, Double.parseDouble("1.0"));
    }

    public SimpleOAuthValidator(long timestampWindow, double maxVersion) {
        this.timestampWindow = timestampWindow;
        this.maxVersion = maxVersion;
    }

    public void validateOAuthVersion(double version) throws OAuthProblemException {
        if (version > this.maxVersion) {
            String message = "version in message (" + version + ") is bigger than max expected version (" + this.maxVersion + ").";
            throw new OAuthProblemException(message);
        }
    }

    public void validateTimestampAndNonce(long timestamp, String nonce) throws OAuthProblemException {
        long now = this.env.getCurrentTime();
        if (Math.abs(now - timestamp) > this.timestampWindow) {
            String message = "timestamp in message is too old. time now is " + now / 1000L + " timestamp is from " + timestamp / 1000L + ".";
            throw new OAuthProblemException(message);
        }
    }

    void setEnvForTesting(Env env) {
        this.env = env;
    }

    static class Env {
        Env() {
        }

        public long getCurrentTime() {
            return new Date().getTime();
        }
    }
}

