/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuthClient {
    public void getRequestToken(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        accessor.accessToken = null;
        accessor.tokenSecret = null;
        ArrayList<OAuth.Parameter> parameters = null;
        Object accessorSecret = accessor.getProperty("oauth_accessor_secret");
        if (accessorSecret != null) {
            parameters = new ArrayList<OAuth.Parameter>(1);
            parameters.add(new OAuth.Parameter("oauth_accessor_secret", accessorSecret.toString()));
        }
        OAuthMessage response = this.invoke(accessor, accessor.consumer.serviceProvider.requestTokenURL, parameters);
        accessor.requestToken = response.getParameter("oauth_token");
        accessor.tokenSecret = response.getParameter("oauth_token_secret");
        if (accessor.requestToken == null) {
            OAuthProblemException problem = new OAuthProblemException("parameter_absent");
            problem.setParameter("oauth_parameters_absent", "oauth_token");
            problem.getParameters().putAll(response.getDump());
            throw problem;
        }
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        return this.invoke(accessor.newRequestMessage(null, url, parameters));
    }

    public abstract OAuthMessage invoke(OAuthMessage var1) throws IOException, OAuthException;
}

