/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.ExcerptInputStream;
import net.oauth.http.HttpResponseMessage;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodResponse
extends HttpResponseMessage {
    private final HttpMethod method;
    private final byte[] requestBody;
    private final String requestEncoding;

    public HttpMethodResponse(HttpMethod method, byte[] requestBody, String requestEncoding) throws IOException {
        super(method.getName(), new URL(method.getURI().toString()));
        this.method = method;
        this.requestBody = requestBody;
        this.requestEncoding = requestEncoding;
        this.headers.addAll(this.getHeaders());
    }

    @Override
    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    @Override
    public InputStream openBody() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    private List<Map.Entry<String, String>> getHeaders() {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        Header[] allHeaders = this.method.getResponseHeaders();
        if (allHeaders != null) {
            for (Header header : allHeaders) {
                headers.add(new OAuth.Parameter(header.getName(), header.getValue()));
            }
        }
        return headers;
    }

    @Override
    public void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        StringBuilder request = new StringBuilder(this.method.getName());
        request.append(" ").append(this.method.getPath());
        String query = this.method.getQueryString();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\r\n");
        for (Header header : this.method.getRequestHeaders()) {
            request.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
        }
        request.append("\r\n");
        if (this.requestBody != null) {
            request.append(new String(this.requestBody, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        StringBuilder response = new StringBuilder();
        String value = this.method.getStatusLine().toString();
        response.append(value).append("\r\n");
        for (Header header : this.method.getResponseHeaders()) {
            String name = header.getName();
            value = header.getValue();
            response.append(name).append(": ").append(value).append("\r\n");
        }
        response.append("\r\n");
        if (this.body != null) {
            response.append(new String(((ExcerptInputStream)this.body).getExcerpt(), this.getContentCharset()));
        }
        into.put("HTTP response", response.toString());
    }
}

