/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.pool.DynamicEnumClass;
import net.openhft.chronicle.core.pool.StaticEnumClass;
import net.openhft.chronicle.core.util.CoreDynamicEnum;

public abstract class EnumCache<E> {
    private static final ClassLocal<EnumCache<?>> ENUM_CACHE_CL = ClassLocal.withInitial(EnumCache::createFromUnknownClass);
    protected final Class<E> type;

    protected EnumCache(Class<E> type) {
        this.type = type;
    }

    public static <E> EnumCache<E> of(Class<E> eClass) {
        return (EnumCache)ENUM_CACHE_CL.get(eClass);
    }

    public E get(String name) {
        return this.valueOf(name);
    }

    public abstract E valueOf(String var1);

    public abstract int size();

    public Class<?> type() {
        return this.type;
    }

    public abstract E forIndex(int var1);

    public abstract E[] asArray();

    public abstract <T> Map<E, T> createMap();

    public abstract Set<E> createSet();

    private static <E, D extends CoreDynamicEnum<D>, S extends Enum<S>> EnumCache<E> createFromUnknownClass(Class<E> eClass) {
        return CoreDynamicEnum.class.isAssignableFrom(eClass) ? new DynamicEnumClass<E>(eClass) : new StaticEnumClass<E>(eClass);
    }
}

