/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.MappingFunction;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.tcp.ChronicleTcp;
import net.openhft.chronicle.tcp.SinkTcp;
import net.openhft.chronicle.tools.WrappedChronicle;
import net.openhft.chronicle.tools.WrappedExcerpt;
import net.openhft.chronicle.tools.WrappedExcerptAppender;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChronicleQueueSink
extends WrappedChronicle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChronicleQueueSink.class);
    private final SinkTcp connection;
    private final ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder;
    private final boolean isLocal;
    private final int readSpinCount;
    private volatile boolean closed;
    private ExcerptCommon excerpt;

    ChronicleQueueSink(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder, SinkTcp connection) {
        super(builder.chronicle());
        this.connection = connection;
        this.builder = builder.clone();
        this.closed = false;
        this.isLocal = builder.sharedChronicle() && connection.isLocalhost();
        this.excerpt = null;
        this.readSpinCount = builder.readSpinCount();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.connection != null) {
                this.connection.close();
            }
        }
        super.close();
    }

    @Override
    public Excerpt createExcerpt() throws IOException {
        return (Excerpt)this.createExcerpt0();
    }

    @Override
    public synchronized ExcerptTailer createTailer() throws IOException {
        return (ExcerptTailer)this.createExcerpt0();
    }

    @Override
    public ExcerptAppender createAppender() throws IOException {
        throw new UnsupportedOperationException();
    }

    private ExcerptCommon createExcerpt0() throws IOException {
        if (this.excerpt != null) {
            throw new IllegalStateException("An excerpt has already been created");
        }
        this.excerpt = this.isLocal ? new StatefulLocalExcerpt(this.wrappedChronicle.createTailer()) : new StatefulExcerpt(this.wrappedChronicle.createTailer());
        return this.excerpt;
    }

    private AppenderAdapter createAppenderAdapter() throws IOException {
        if (this.wrappedChronicle instanceof IndexedChronicle) {
            return new IndexedAppenderAdapter(this.wrappedChronicle, this.wrappedChronicle.createAppender());
        }
        if (this.wrappedChronicle instanceof VanillaChronicle) {
            return new VanillaAppenderAdapter(this.wrappedChronicle, this.wrappedChronicle.createAppender());
        }
        throw new IllegalArgumentException("Can only adapt Indexed or Vanilla chronicles");
    }

    private final class VanillaAppenderAdapter
    extends AppenderAdapter {
        private final VanillaChronicle chronicle;
        private final VanillaChronicle.VanillaAppender appender;

        public VanillaAppenderAdapter(@NotNull Chronicle chronicle, ExcerptAppender appender) {
            super(appender);
            this.chronicle = (VanillaChronicle)chronicle;
            this.appender = (VanillaChronicle.VanillaAppender)appender;
        }

        @Override
        public void writePaddedEntry() {
            LOGGER.warn("VanillaChronicle should not receive padded entries");
        }

        @Override
        public void startExcerpt(long capacity, long index) {
            int cycle = (int)(index >>> this.chronicle.getEntriesForCycleBits());
            this.appender.startExcerpt(capacity, cycle);
        }
    }

    private final class IndexedAppenderAdapter
    extends AppenderAdapter {
        private final IndexedChronicle chronicle;

        public IndexedAppenderAdapter(@NotNull Chronicle chronicle, ExcerptAppender appender) {
            super(appender);
            this.chronicle = (IndexedChronicle)chronicle;
        }

        @Override
        public void writePaddedEntry() {
            ((ExcerptAppender)this.wrapped).addPaddedEntry();
        }

        @Override
        public void startExcerpt(long capacity, long index) {
            ((ExcerptAppender)this.wrapped).startExcerpt(capacity);
        }
    }

    private abstract class AppenderAdapter
    extends WrappedExcerptAppender<ExcerptAppender> {
        public AppenderAdapter(ExcerptAppender appender) {
            super(appender);
        }

        public abstract void writePaddedEntry();

        public abstract void startExcerpt(long var1, long var3);
    }

    private final class StatefulExcerpt
    extends AbstractStatefulExcerpt {
        private AppenderAdapter adapter;
        private long lastLocalIndex;

        public StatefulExcerpt(ExcerptCommon common) {
            super(common);
            this.adapter = null;
            this.lastLocalIndex = -1L;
            this.withMapping(ChronicleQueueSink.this.builder.withMapping());
        }

        @Override
        protected boolean readNext() {
            if (!ChronicleQueueSink.this.closed && !ChronicleQueueSink.this.connection.isOpen()) {
                try {
                    ChronicleQueueSink.this.connection.open();
                    this.readBuffer.clear();
                    this.readBuffer.limit(0);
                    if (this.adapter == null) {
                        this.adapter = ChronicleQueueSink.this.createAppenderAdapter();
                    }
                    this.lastLocalIndex = ChronicleQueueSink.this.wrappedChronicle.lastIndex();
                    this.subscribe(this.lastLocalIndex);
                }
                catch (IOException e) {
                    this.logger.warn("Error closing socketChannel", (Throwable)e);
                    return false;
                }
            }
            return ChronicleQueueSink.this.connection.isOpen() && this.readNextExcerpt();
        }

        private boolean readNextExcerpt() {
            try {
                if (!ChronicleQueueSink.this.closed && !ChronicleQueueSink.this.connection.read(this.readBuffer, 12, 20, ChronicleQueueSink.this.readSpinCount)) {
                    return false;
                }
                int size = this.readBuffer.getInt();
                long scIndex = this.readBuffer.getLong();
                switch (size) {
                    case -128: {
                        return false;
                    }
                    case -127: {
                        this.adapter.writePaddedEntry();
                        return this.readNextExcerpt();
                    }
                    case -126: {
                        return this.readNextExcerpt();
                    }
                }
                if (size > 0x8000000 || size < 0) {
                    throw new StreamCorruptedException("size was " + size);
                }
                if (this.lastLocalIndex != scIndex) {
                    this.adapter.startExcerpt(size, scIndex);
                    long remaining = size;
                    int limit = this.readBuffer.limit();
                    int size2 = (int)Math.min((long)this.readBuffer.remaining(), remaining);
                    remaining -= (long)size2;
                    this.readBuffer.limit(this.readBuffer.position() + size2);
                    this.adapter.write(this.readBuffer);
                    this.readBuffer.limit(limit);
                    while (remaining > 0L) {
                        int size3 = (int)Math.min((long)this.readBuffer.capacity(), remaining);
                        ChronicleQueueSink.this.connection.readUpTo(this.readBuffer, size3, -1);
                        remaining -= (long)this.readBuffer.remaining();
                        this.adapter.write(this.readBuffer);
                    }
                } else {
                    this.readBuffer.position(this.readBuffer.position() + size);
                    return this.readNextExcerpt();
                }
                this.adapter.finish();
            }
            catch (IOException e1) {
                if (e1 instanceof EOFException) {
                    this.logger.trace("Exception reading nextExcerpt", (Throwable)e1);
                } else {
                    this.logger.warn("Exception reading nextExcerpt", (Throwable)e1);
                }
                try {
                    ChronicleQueueSink.this.connection.close();
                }
                catch (IOException e2) {
                    this.logger.warn("Error closing socketChannel", (Throwable)e2);
                }
            }
            return true;
        }

        @Override
        public void close() {
            if (this.adapter != null) {
                this.adapter.close();
                this.adapter = null;
            }
            super.close();
        }
    }

    private class StatefulLocalExcerpt
    extends AbstractStatefulExcerpt {
        public StatefulLocalExcerpt(ExcerptCommon common) {
            super(common);
        }

        @Override
        protected boolean readNext() {
            if (!ChronicleQueueSink.this.closed && !ChronicleQueueSink.this.connection.isOpen()) {
                try {
                    ChronicleQueueSink.this.connection.open();
                    this.readBuffer.clear();
                    this.readBuffer.limit(0);
                }
                catch (IOException e) {
                    this.logger.warn("Error closing socketChannel", (Throwable)e);
                    return false;
                }
            }
            return ChronicleQueueSink.this.connection.isOpen() && this.readNextExcerpt();
        }

        private boolean readNextExcerpt() {
            try {
                if (!ChronicleQueueSink.this.closed) {
                    this.query(ChronicleQueueSink.this.wrappedChronicle.lastIndex());
                    if (ChronicleQueueSink.this.connection.readUpTo(this.readBuffer, 12, ChronicleQueueSink.this.readSpinCount)) {
                        int size = this.readBuffer.getInt();
                        long scIndex = this.readBuffer.getLong();
                        switch (size) {
                            case -128: {
                                return false;
                            }
                            case -127: {
                                return false;
                            }
                            case -126: {
                                return true;
                            }
                        }
                    }
                }
            }
            catch (IOException e1) {
                this.logger.warn("Exception reading nextExcerpt", (Throwable)e1);
                try {
                    ChronicleQueueSink.this.connection.close();
                }
                catch (IOException e2) {
                    this.logger.warn("Error closing socketChannel", (Throwable)e2);
                }
            }
            return false;
        }
    }

    private abstract class AbstractStatefulExcerpt
    extends WrappedExcerpt {
        protected final Logger logger;
        protected final ByteBuffer writeBuffer;
        protected final ByteBufferBytes writeBufferBytes;
        protected final ByteBuffer readBuffer;

        protected AbstractStatefulExcerpt(ExcerptCommon excerpt) {
            super(excerpt);
            this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "@" + ChronicleQueueSink.this.connection.toString()));
            this.writeBuffer = ChronicleTcp.createBuffer(16);
            this.writeBufferBytes = new ByteBufferBytes(this.writeBuffer);
            this.readBuffer = ChronicleTcp.createBuffer(ChronicleQueueSink.this.builder.minBufferSize());
        }

        @Override
        public boolean nextIndex() {
            return super.nextIndex() || this.readNext() && super.nextIndex();
        }

        @Override
        public boolean index(long index) throws IndexOutOfBoundsException {
            return super.index(index) || index >= 0L && this.readNext() && super.index(index);
        }

        public synchronized void close() {
            try {
                ChronicleQueueSink.this.connection.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing socketChannel", (Throwable)e);
            }
            super.close();
            ChronicleQueueSink.this.excerpt = null;
        }

        protected void subscribe(long index) throws IOException {
            this.writeBuffer.clear();
            this.writeBufferBytes.clear();
            this.writeBufferBytes.writeLong(1L);
            this.writeBufferBytes.writeLong(index);
            MappingFunction mapping = this.withMapping();
            if (mapping != null) {
                this.writeBufferBytes.writeLong(30L);
                long pos = this.writeBufferBytes.position();
                this.writeBufferBytes.skip(4L);
                long start = this.writeBufferBytes.position();
                this.writeBufferBytes.writeObject((Object)mapping);
                int len = (int)(this.writeBufferBytes.position() - start);
                this.writeBufferBytes.writeInt(pos, len);
            }
            this.writeBuffer.position(0);
            this.writeBuffer.limit((int)this.writeBufferBytes.position());
            ChronicleQueueSink.this.connection.writeAllOrEOF(this.writeBuffer);
        }

        protected void query(long index) throws IOException {
            this.writeBuffer.clear();
            this.writeBuffer.putLong(10L);
            this.writeBuffer.putLong(index);
            this.writeBuffer.flip();
            ChronicleQueueSink.this.connection.writeAllOrEOF(this.writeBuffer);
        }

        protected abstract boolean readNext();
    }
}

