/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.IOException;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.tcp.SourceTcp;
import net.openhft.chronicle.tools.WrappedChronicle;
import net.openhft.chronicle.tools.WrappedExcerpt;

class ChronicleQueueSource
extends WrappedChronicle {
    private final SourceTcp connection;
    private final ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder;
    private volatile boolean closed;

    ChronicleQueueSource(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder, SourceTcp connection) {
        super(builder.chronicle());
        this.builder = builder.clone();
        this.closed = false;
        this.connection = connection;
        this.connection.open();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.connection != null) {
                this.connection.close();
            }
        }
        super.close();
    }

    @Override
    public Excerpt createExcerpt() throws IOException {
        return new SourceExcerpt(this.wrappedChronicle.createExcerpt());
    }

    @Override
    public ExcerptTailer createTailer() throws IOException {
        return new SourceExcerpt(this.wrappedChronicle.createTailer());
    }

    @Override
    public ExcerptAppender createAppender() throws IOException {
        return new SourceExcerpt(this.wrappedChronicle.createAppender());
    }

    final class SourceExcerpt
    extends WrappedExcerpt {
        public SourceExcerpt(ExcerptCommon excerptCommon) {
            super(excerptCommon);
        }

        @Override
        public void finish() {
            super.finish();
            ChronicleQueueSource.this.connection.dataNotification();
        }
    }
}

