/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.ChronicleTcp;
import net.openhft.chronicle.tcp.TcpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SinkTcp
extends TcpConnection {
    protected final Logger logger;
    protected final String name;
    protected final AtomicBoolean running;
    protected final ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder;

    protected SinkTcp(String name, ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        this.builder = builder;
        this.name = ChronicleTcp.connectionName(name, this.builder.bindAddress(), this.builder.connectAddress());
        this.logger = LoggerFactory.getLogger((String)this.name);
        this.running = new AtomicBoolean(false);
    }

    public String toString() {
        return this.name;
    }

    public SinkTcp open() throws IOException {
        return this.open(false);
    }

    public SinkTcp open(boolean blocking) throws IOException {
        this.close();
        this.running.set(true);
        SocketChannel socketChannel = this.openSocketChannel();
        if (socketChannel != null) {
            socketChannel.configureBlocking(blocking);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setSoTimeout(0);
            socketChannel.socket().setSoLinger(false, 0);
            if (this.builder.receiveBufferSize() > 0) {
                socketChannel.socket().setReceiveBufferSize(this.builder.receiveBufferSize());
            }
            if (this.builder.sendBufferSize() > 0) {
                socketChannel.socket().setSendBufferSize(this.builder.sendBufferSize());
            }
            super.setSocketChannel(socketChannel);
        }
        this.running.set(false);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.running.set(false);
        super.close();
    }

    public abstract boolean isLocalhost();

    protected abstract SocketChannel openSocketChannel() throws IOException;
}

