/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteIntMap}s.
 *
 * @see HashByteIntMap
 * @see HashByteIntMaps#getDefaultFactory()
 */
public interface HashByteIntMapFactory
        extends ByteIntMapFactory<HashByteIntMapFactory>
        , ByteHashFactory<HashByteIntMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteIntMap newMutableMap();

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(
            @Nonnull Map<Byte, Integer> map);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5);



    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashByteIntMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashByteIntMap newMutableMapOf(byte k1, int v1);

    @Override
    @Nonnull
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
    @Nonnull
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
    @Nonnull
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
    @Nonnull
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(
            @Nonnull Map<Byte, Integer> map);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5);



    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashByteIntMap newUpdatableMapOf(byte k1, int v1);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
    @Nonnull
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);

    


    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(
            @Nonnull Map<Byte, Integer> map);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Map<Byte, Integer> map1,
            @Nonnull Map<Byte, Integer> map2,
            @Nonnull Map<Byte, Integer> map3,
            @Nonnull Map<Byte, Integer> map4,
            @Nonnull Map<Byte, Integer> map5);



    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashByteIntMap newImmutableMapOf(byte k1, int v1);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
    @Nonnull
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
}

