/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharCharMap}s.
 *
 * @see HashCharCharMap
 * @see HashCharCharMaps#getDefaultFactory()
 */
public interface HashCharCharMapFactory
        extends CharCharMapFactory<HashCharCharMapFactory>
        , CharHashFactory<HashCharCharMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharCharMap newMutableMap();

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(
            @Nonnull char[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(
            @Nonnull Map<Character, Character> map);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5);



    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(
            @Nonnull char[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashCharCharMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashCharCharMap newMutableMapOf(char k1, char v1);

    @Override
    @Nonnull
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
    @Nonnull
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
    @Nonnull
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
    @Nonnull
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(
            @Nonnull Map<Character, Character> map);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5);



    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashCharCharMap newUpdatableMapOf(char k1, char v1);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
    @Nonnull
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);

    


    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(
            @Nonnull Map<Character, Character> map);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Map<Character, Character> map1,
            @Nonnull Map<Character, Character> map2,
            @Nonnull Map<Character, Character> map3,
            @Nonnull Map<Character, Character> map4,
            @Nonnull Map<Character, Character> map5);



    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashCharCharMap newImmutableMapOf(char k1, char v1);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
    @Nonnull
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
}

