/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleObjMap}s.
 *
 * @see HashDoubleObjMap
 * @see HashDoubleObjMaps#getDefaultFactory()
 */
public interface HashDoubleObjMapFactory<V>
        extends DoubleObjMapFactory<V, HashDoubleObjMapFactory<V>>
        , HashContainerFactory<HashDoubleObjMapFactory<V>>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap();

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(
            @Nonnull double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(
            @Nonnull Map<Double, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(
            @Nonnull double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMapOf(double k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMapOf(double k1, V2 v1,
            double k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newMutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4, double k5, V2 v5);
    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap();

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(
            @Nonnull double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(
            @Nonnull Map<Double, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(
            @Nonnull double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMapOf(double k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMapOf(double k1, V2 v1,
            double k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newUpdatableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4, double k5, V2 v5);

    


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(
            @Nonnull double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(
            @Nonnull Map<Double, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Map<Double, ? extends V2> map1,
            @Nonnull Map<Double, ? extends V2> map2,
            @Nonnull Map<Double, ? extends V2> map3,
            @Nonnull Map<Double, ? extends V2> map4,
            @Nonnull Map<Double, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(
            @Nonnull double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(
            @Nonnull Double[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMapOf(double k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMapOf(double k1, V2 v1,
            double k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashDoubleObjMap<V2> newImmutableMapOf(double k1, V2 v1,
            double k2, V2 v2, double k3, V2 v3,
            double k4, V2 v4, double k5, V2 v5);
}

