/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntIntMap}s.
 *
 * @see HashIntIntMap
 * @see HashIntIntMaps#getDefaultFactory()
 */
public interface HashIntIntMapFactory
        extends IntIntMapFactory<HashIntIntMapFactory>
        , IntHashFactory<HashIntIntMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntIntMap newMutableMap();

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(
            @Nonnull int[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(
            @Nonnull Map<Integer, Integer> map);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5);



    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(
            @Nonnull int[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashIntIntMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashIntIntMap newMutableMapOf(int k1, int v1);

    @Override
    @Nonnull
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
    @Nonnull
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
    @Nonnull
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
    @Nonnull
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(
            @Nonnull Map<Integer, Integer> map);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5);



    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashIntIntMap newUpdatableMapOf(int k1, int v1);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
    @Nonnull
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);

    


    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(
            @Nonnull Map<Integer, Integer> map);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Map<Integer, Integer> map1,
            @Nonnull Map<Integer, Integer> map2,
            @Nonnull Map<Integer, Integer> map3,
            @Nonnull Map<Integer, Integer> map4,
            @Nonnull Map<Integer, Integer> map5);



    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashIntIntMap newImmutableMapOf(int k1, int v1);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
    @Nonnull
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
}

