/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongFloatMap}s.
 *
 * @see HashLongFloatMap
 * @see HashLongFloatMaps#getDefaultFactory()
 */
public interface HashLongFloatMapFactory
        extends LongFloatMapFactory<HashLongFloatMapFactory>
        , LongHashFactory<HashLongFloatMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongFloatMap newMutableMap();

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(
            @Nonnull long[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(
            @Nonnull Map<Long, Float> map);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5);



    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(
            @Nonnull long[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashLongFloatMap newMutableMapOf(long k1, float v1);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
    @Nonnull
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(
            @Nonnull Map<Long, Float> map);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5);



    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMapOf(long k1, float v1);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
    @Nonnull
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);

    


    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(
            @Nonnull Map<Long, Float> map);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Map<Long, Float> map1,
            @Nonnull Map<Long, Float> map2,
            @Nonnull Map<Long, Float> map3,
            @Nonnull Map<Long, Float> map4,
            @Nonnull Map<Long, Float> map5);



    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashLongFloatMap newImmutableMapOf(long k1, float v1);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
    @Nonnull
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
}

