/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortByteMap}s.
 *
 * @see HashShortByteMap
 * @see HashShortByteMaps#getDefaultFactory()
 */
public interface HashShortByteMapFactory
        extends ShortByteMapFactory<HashShortByteMapFactory>
        , ShortHashFactory<HashShortByteMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortByteMap newMutableMap();

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(
            @Nonnull short[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(
            @Nonnull Map<Short, Byte> map);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5);



    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(
            @Nonnull short[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashShortByteMap newMutableMapOf(short k1, byte v1);

    @Override
    @Nonnull
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
    @Nonnull
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
    @Nonnull
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
    @Nonnull
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(
            @Nonnull Map<Short, Byte> map);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5);



    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashShortByteMap newUpdatableMapOf(short k1, byte v1);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
    @Nonnull
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);

    


    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(
            @Nonnull Map<Short, Byte> map);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Map<Short, Byte> map1,
            @Nonnull Map<Short, Byte> map2,
            @Nonnull Map<Short, Byte> map3,
            @Nonnull Map<Short, Byte> map4,
            @Nonnull Map<Short, Byte> map5);



    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashShortByteMap newImmutableMapOf(short k1, byte v1);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
    @Nonnull
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
}

