/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortDoubleMap}s.
 *
 * @see HashShortDoubleMap
 * @see HashShortDoubleMaps#getDefaultFactory()
 */
public interface HashShortDoubleMapFactory
        extends ShortDoubleMapFactory<HashShortDoubleMapFactory>
        , ShortHashFactory<HashShortDoubleMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(
            @Nonnull short[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(
            @Nonnull Map<Short, Double> map);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5);



    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(
            @Nonnull short[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashShortDoubleMap newMutableMapOf(short k1, double v1);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
    @Nonnull
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(
            @Nonnull Map<Short, Double> map);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5);



    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
    @Nonnull
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);

    


    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(
            @Nonnull Map<Short, Double> map);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Map<Short, Double> map1,
            @Nonnull Map<Short, Double> map2,
            @Nonnull Map<Short, Double> map3,
            @Nonnull Map<Short, Double> map4,
            @Nonnull Map<Short, Double> map5);



    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMapOf(short k1, double v1);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
    @Nonnull
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
}

