/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortObjMap}s.
 *
 * @see HashShortObjMap
 * @see HashShortObjMaps#getDefaultFactory()
 */
public interface HashShortObjMapFactory<V>
        extends ShortObjMapFactory<V, HashShortObjMapFactory<V>>
        , ShortHashFactory<HashShortObjMapFactory<V>>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap();

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            @Nonnull short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            @Nonnull Map<Short, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            @Nonnull short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap();

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            @Nonnull short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            @Nonnull Map<Short, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            @Nonnull short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);

    


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            @Nonnull short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            @Nonnull Map<Short, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Map<Short, ? extends V2> map1,
            @Nonnull Map<Short, ? extends V2> map2,
            @Nonnull Map<Short, ? extends V2> map3,
            @Nonnull Map<Short, ? extends V2> map4,
            @Nonnull Map<Short, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            @Nonnull short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            @Nonnull Short[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
}

