/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.function;


/**
 * Represents a function that accepts
 * 
 * two {@code long}-valued arguments
 * 
 * and produces a {@code long}-valued result.
 * This is the {@code (long, long, long)}
 * specialization of {@link BiFunction}.
 *
 * 
 * <p>Unlike {@link LongBinaryOperator}, this function is supposed to accept heterogeneous
 * arguments, e. g. key and value
 * in {@link net.openhft.koloboke.collect.map.LongLongMap#compute(long, LongLongToLongFunction)}
 * method.
 * 
 *
 * 
 * @see BiFunction
 */
@FunctionalInterface
public interface LongLongToLongFunction {

    /**
     * Applies this function to the given arguments.
     *
     * @param a the first function argument
     * @param b the second function argument
     * @return the function result
     */
    long applyAsLong(long a, long b);
}

