/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import net.openhft.koloboke.collect.impl.*;
import net.openhft.koloboke.collect.map.hash.HashShortIntMapFactory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.koloboke.collect.map.hash.HashShortIntMap;

import javax.annotation.Nonnull;
import java.util.*;

import static net.openhft.koloboke.collect.impl.Containers.sizeAsInt;
import static net.openhft.koloboke.collect.impl.hash.LHashCapacities.configIsSuitableForMutableLHash;


public abstract class LHashSeparateKVShortIntMapFactoryGO
        extends LHashSeparateKVShortIntMapFactorySO {

    LHashSeparateKVShortIntMapFactoryGO(HashConfig hashConf, int defaultExpectedSize
            , short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    

    abstract HashShortIntMapFactory thisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper);

    abstract HashShortIntMapFactory lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper);

    abstract HashShortIntMapFactory qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, short lower, short upper);

    @Override
    public final HashShortIntMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (configIsSuitableForMutableLHash(hashConf))
            return lHashLikeThisWith(hashConf, getDefaultExpectedSize()
            
                    , getLowerKeyDomainBound(), getUpperKeyDomainBound());
        return qHashLikeThisWith(hashConf, getDefaultExpectedSize()
            
                , getLowerKeyDomainBound(), getUpperKeyDomainBound());
    }

    @Override
    public final HashShortIntMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == getDefaultExpectedSize())
            return this;
        return thisWith(getHashConfig(), defaultExpectedSize
                
                , getLowerKeyDomainBound(), getUpperKeyDomainBound());
    }

    final HashShortIntMapFactory withDomain(short lower, short upper) {
        if (lower == getLowerKeyDomainBound() && upper == getUpperKeyDomainBound())
            return this;
        return thisWith(getHashConfig(), getDefaultExpectedSize(), lower, upper);
    }

    @Override
    public final HashShortIntMapFactory withKeysDomain(short lower, short upper) {
        if (lower > upper)
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater " +
                    "than maxPossibleKey");
        return withDomain(lower, upper);
    }

    @Override
    public final HashShortIntMapFactory withKeysDomainComplement(short lower, short upper) {
        if (lower > upper)
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater " +
                    "than maxImpossibleKey");
        return withDomain((short) (upper + 1), (short) (lower - 1));
    }

    @Override
    public String toString() {
        return "HashShortIntMapFactory[" + commonString() + keySpecialString() +
                ",defaultValue=" + getDefaultValue() +
        "]";
    }

    @Override
    public int hashCode() {
        int hashCode = keySpecialHashCode(commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(getDefaultValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj instanceof HashShortIntMapFactory) {
            HashShortIntMapFactory factory = (HashShortIntMapFactory) obj;
            return commonEquals(factory) && keySpecialEquals(factory) &&
                    // boxing to treat NaNs correctly
                   ((Integer) getDefaultValue()).equals(factory.getDefaultValue())
                    ;
        } else {
            return false;
        }
    }

    @Override
    public int getDefaultValue() {
        return 0;
    }

    

    

    

    

    

    

    
    

    
    

    private  UpdatableLHashSeparateKVShortIntMapGO shrunk(
            UpdatableLHashSeparateKVShortIntMapGO map) {
        Predicate<HashContainer> shrinkCondition;
        if ((shrinkCondition = hashConf.getShrinkCondition()) != null) {
            if (shrinkCondition.test(map))
                map.shrink();
        }
        return map;
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap() {
        return newUpdatableMap(getDefaultExpectedSize());
    }
    @Override
    @Nonnull
    public  MutableLHashSeparateKVShortIntMapGO newMutableMap() {
        return newMutableMap(getDefaultExpectedSize());
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map) {
        return shrunk(super.newUpdatableMap(map));
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        return newUpdatableMap(map1, map2, sizeAsInt(expectedSize));
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        return newUpdatableMap(map1, map2, map3, sizeAsInt(expectedSize));
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3, Map<Short, Integer> map4) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        expectedSize += (long) map4.size();
        return newUpdatableMap(map1, map2, map3, map4, sizeAsInt(expectedSize));
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3, Map<Short, Integer> map4,
            Map<Short, Integer> map5) {
        long expectedSize = (long) map1.size();
        expectedSize += (long) map2.size();
        expectedSize += (long) map3.size();
        expectedSize += (long) map4.size();
        expectedSize += (long) map5.size();
        return newUpdatableMap(map1, map2, map3, map4, map5, sizeAsInt(expectedSize));
    }


    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3, int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3, Map<Short, Integer> map4,
            int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        map.putAll(map4);
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Map<Short, Integer> map1, Map<Short, Integer> map2,
            Map<Short, Integer> map3, Map<Short, Integer> map4,
            Map<Short, Integer> map5, int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        map.putAll(map1);
        map.putAll(map2);
        map.putAll(map3);
        map.putAll(map4);
        map.putAll(map5);
        return shrunk(map);
    }


    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier) {
        return newUpdatableMap(entriesSupplier, getDefaultExpectedSize());
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier,
            int expectedSize) {
        final UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        entriesSupplier.accept(new net.openhft.koloboke.function.ShortIntConsumer() {
             @Override
             public void accept(short k, int v) {
                 map.put(k, v);
             }
         });
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            short[] keys, int[] values) {
        return newUpdatableMap(keys, values, keys.length);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            short[] keys, int[] values, int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length)
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        for (int i = 0; i < keys.length; i++) {
            map.put(keys[i], values[i]);
        }
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Short[] keys, Integer[] values) {
        return newUpdatableMap(keys, values, keys.length);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length)
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        for (int i = 0; i < keys.length; i++) {
            map.put(keys[i], values[i]);
        }
        return shrunk(map);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Iterable<Short> keys, Iterable<Integer> values) {
        int expectedSize = keys instanceof Collection ? ((Collection) keys).size() :
                getDefaultExpectedSize();
        return newUpdatableMap(keys, values, expectedSize);
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMap(
            Iterable<Short> keys, Iterable<Integer> values, int expectedSize) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(expectedSize);
        Iterator<Short> keysIt = keys.iterator();
        Iterator<Integer> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return shrunk(map);
        } catch (NoSuchElementException e) {
            throw new IllegalArgumentException(
                    "keys and values iterables must have the same size", e);
        }
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMapOf(
            short k1, int v1) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    @Override
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMapOf(
            short k1, int v1, short k2, int v2) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    @Override
    @Nonnull
    public  UpdatableLHashSeparateKVShortIntMapGO newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4,
            short k5, int v5) {
        UpdatableLHashSeparateKVShortIntMapGO map = newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    
    


    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5, expectedSize));
        return res;
    }



    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier
            , int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(entriesSupplier, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(short[] keys,
            int[] values, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    
    

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(
            Map<Short, Integer> map) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5) {
        MutableLHashSeparateKVShortIntMapGO res = uninitializedMutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5));
        return res;
    }



    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier
            ) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(entriesSupplier));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(short[] keys,
            int[] values) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }


    @Override
    @Nonnull
    public  HashShortIntMap newMutableMapOf(short k1, int v1) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMapOf(short k1, int v1,
             short k2, int v2) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3,
             short k4, int v4) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newMutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3,
             short k4, int v4, short k5, int v5) {
        MutableLHashSeparateKVShortIntMapGO map = uninitializedMutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
    
    


    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, expectedSize));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5, expectedSize));
        return res;
    }



    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier
            , int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(entriesSupplier, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(short[] keys,
            int[] values, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    
    

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(
            Map<Short, Integer> map) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4));
        return res;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5) {
        ImmutableLHashSeparateKVShortIntMapGO res = uninitializedImmutableMap();
        res.move(newUpdatableMap(map1, map2, map3, map4, map5));
        return res;
    }



    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(
            Consumer<net.openhft.koloboke.function.ShortIntConsumer> entriesSupplier
            ) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(entriesSupplier));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(short[] keys,
            int[] values) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMap(keys, values));
        return map;
    }


    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMapOf(short k1, int v1) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMapOf(short k1, int v1,
             short k2, int v2) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3,
             short k4, int v4) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    @Override
    @Nonnull
    public  HashShortIntMap newImmutableMapOf(short k1, int v1,
             short k2, int v2, short k3, int v3,
             short k4, int v4, short k5, int v5) {
        ImmutableLHashSeparateKVShortIntMapGO map = uninitializedImmutableMap();
        map.move(newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

