/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedFile;

public class VanillaMappedCache<T>
implements Closeable {
    private final boolean cleanOnClose;
    private final Map<T, VanillaMappedBytes> cache;

    public VanillaMappedCache() {
        this(new LinkedHashMap(), false);
    }

    public VanillaMappedCache(boolean cleanOnClose) {
        this(new LinkedHashMap(), cleanOnClose);
    }

    public VanillaMappedCache(int maximumCacheSize, boolean releaseOnRemove) {
        this(maximumCacheSize, releaseOnRemove, false);
    }

    public VanillaMappedCache(final int maximumCacheSize, final boolean releaseOnRemove, boolean cleanOnClose) {
        this(new LinkedHashMap<T, VanillaMappedBytes>(maximumCacheSize, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, VanillaMappedBytes> eldest) {
                boolean removed;
                boolean bl = removed = this.size() >= maximumCacheSize;
                if (removed && releaseOnRemove) {
                    eldest.getValue().release();
                }
                return removed;
            }
        }, cleanOnClose);
    }

    private VanillaMappedCache(Map<T, VanillaMappedBytes> cache, boolean cleanOnClose) {
        this.cache = cache;
        this.cleanOnClose = cleanOnClose;
    }

    public VanillaMappedBytes get(T key) {
        return this.cache.get(key);
    }

    public VanillaMappedBytes put(T key, File path, long size) throws IOException {
        return this.put(key, path, size, -1L);
    }

    public VanillaMappedBytes put(T key, File path, long size, long index) throws IOException {
        VanillaMappedBytes data = this.cache.get(key);
        if (data != null && !data.unmapped()) {
            data.cleanup();
            throw new IllegalStateException("Buffer at " + data.index() + " has a count of " + data.refCount());
        }
        data = VanillaMappedFile.readWriteBytes(path, size, index);
        this.cache.put(key, data);
        return data;
    }

    public int size() {
        return this.cache.size();
    }

    @Override
    public void close() {
        Iterator<Map.Entry<T, VanillaMappedBytes>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, VanillaMappedBytes> entry = it.next();
            entry.getValue().release();
            if (this.cleanOnClose && !entry.getValue().unmapped()) {
                entry.getValue().cleanup();
                entry.getValue().close();
                it.remove();
                continue;
            }
            if (!entry.getValue().unmapped()) continue;
            entry.getValue().close();
            it.remove();
        }
        this.cache.clear();
    }

    public synchronized void checkCounts(int min, int max) {
        for (VanillaMappedBytes data : this.cache.values()) {
            if (data.refCount() >= min && data.refCount() <= max) continue;
            throw new IllegalStateException("Buffer at " + data.index() + " has a count of " + data.refCount());
        }
    }
}

