/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import androidx.annotation.NonNull;
import net.openid.appauth.Preconditions;
import net.openid.appauth.browser.AnyBrowserMatcher;
import net.openid.appauth.browser.BrowserMatcher;
import net.openid.appauth.connectivity.ConnectionBuilder;
import net.openid.appauth.connectivity.DefaultConnectionBuilder;

public class AppAuthConfiguration {
    public static final AppAuthConfiguration DEFAULT = new Builder().build();
    @NonNull
    private final BrowserMatcher mBrowserMatcher;
    @NonNull
    private final ConnectionBuilder mConnectionBuilder;
    private final boolean mSkipIssuerHttpsCheck;

    private AppAuthConfiguration(@NonNull BrowserMatcher browserMatcher, @NonNull ConnectionBuilder connectionBuilder, Boolean skipIssuerHttpsCheck) {
        this.mBrowserMatcher = browserMatcher;
        this.mConnectionBuilder = connectionBuilder;
        this.mSkipIssuerHttpsCheck = skipIssuerHttpsCheck;
    }

    @NonNull
    public BrowserMatcher getBrowserMatcher() {
        return this.mBrowserMatcher;
    }

    @NonNull
    public ConnectionBuilder getConnectionBuilder() {
        return this.mConnectionBuilder;
    }

    public boolean getSkipIssuerHttpsCheck() {
        return this.mSkipIssuerHttpsCheck;
    }

    public static class Builder {
        private BrowserMatcher mBrowserMatcher = AnyBrowserMatcher.INSTANCE;
        private ConnectionBuilder mConnectionBuilder = DefaultConnectionBuilder.INSTANCE;
        private boolean mSkipIssuerHttpsCheck;
        private boolean mSkipNonceVerification;

        @NonNull
        public Builder setBrowserMatcher(@NonNull BrowserMatcher browserMatcher) {
            Preconditions.checkNotNull(browserMatcher, "browserMatcher cannot be null");
            this.mBrowserMatcher = browserMatcher;
            return this;
        }

        @NonNull
        public Builder setConnectionBuilder(@NonNull ConnectionBuilder connectionBuilder) {
            Preconditions.checkNotNull(connectionBuilder, "connectionBuilder cannot be null");
            this.mConnectionBuilder = connectionBuilder;
            return this;
        }

        public Builder setSkipIssuerHttpsCheck(Boolean skipIssuerHttpsCheck) {
            this.mSkipIssuerHttpsCheck = skipIssuerHttpsCheck;
            return this;
        }

        @NonNull
        public AppAuthConfiguration build() {
            return new AppAuthConfiguration(this.mBrowserMatcher, this.mConnectionBuilder, this.mSkipIssuerHttpsCheck);
        }
    }
}

