/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.util.Base64;
import androidx.annotation.NonNull;
import java.util.Collections;
import java.util.Map;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.Preconditions;
import net.openid.appauth.internal.UriUtil;

public class ClientSecretBasic
implements ClientAuthentication {
    public static final String NAME = "client_secret_basic";
    @NonNull
    private String mClientSecret;

    public ClientSecretBasic(@NonNull String clientSecret) {
        this.mClientSecret = Preconditions.checkNotNull(clientSecret, "mClientSecret cannot be null");
    }

    @Override
    public final Map<String, String> getRequestHeaders(@NonNull String clientId) {
        String encodedClientId = UriUtil.formUrlEncodeValue(clientId);
        String encodedClientSecret = UriUtil.formUrlEncodeValue(this.mClientSecret);
        String credentials = encodedClientId + ":" + encodedClientSecret;
        String basicAuth = Base64.encodeToString((byte[])credentials.getBytes(), (int)2);
        return Collections.singletonMap("Authorization", "Basic " + basicAuth);
    }

    @Override
    public final Map<String, String> getRequestParameters(@NonNull String clientId) {
        return null;
    }
}

