/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.openid.appauth.Preconditions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class JsonUtil {
    private JsonUtil() {
        throw new IllegalStateException("This type is not intended to be instantiated");
    }

    public static void put(@NonNull JSONObject json, @NonNull String field, @NonNull int value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkNotNull(value, "value must not be null");
        try {
            json.put(field, value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract, ex");
        }
    }

    public static void put(@NonNull JSONObject json, @NonNull String field, @NonNull String value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkNotNull(value, "value must not be null");
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void put(@NonNull JSONObject json, @NonNull String field, @NonNull JSONArray value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkNotNull(value, "value must not be null");
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void put(@NonNull JSONObject json, @NonNull String field, @NonNull JSONObject value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        Preconditions.checkNotNull(value, "value must not be null");
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void putIfNotNull(@NonNull JSONObject json, @NonNull String field, @Nullable String value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (value == null) {
            return;
        }
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void putIfNotNull(@NonNull JSONObject json, @NonNull String field, @Nullable Uri value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (value == null) {
            return;
        }
        try {
            json.put(field, (Object)value.toString());
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void putIfNotNull(@NonNull JSONObject json, @NonNull String field, @Nullable Long value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (value == null) {
            return;
        }
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    public static void putIfNotNull(@NonNull JSONObject json, @NonNull String field, @Nullable JSONObject value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (value == null) {
            return;
        }
        try {
            json.put(field, (Object)value);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    @VisibleForTesting
    static void putIfNotNull(@NonNull JSONObject json, @NonNull String field, @Nullable Object value) {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (value == null) {
            return;
        }
        try {
            if (value instanceof Collection) {
                json.put(field, (Object)new JSONArray((Collection)value));
            } else if (value instanceof Map) {
                Map map = (Map)value;
                JSONObject valueObj = new JSONObject();
                for (String key : map.keySet()) {
                    JsonUtil.putIfNotNull(valueObj, key, map.get(key));
                }
                json.put(field, (Object)valueObj);
            } else {
                json.put(field, value);
            }
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSONException thrown in violation of contract", ex);
        }
    }

    @NonNull
    public static String getString(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            throw new JSONException("field \"" + field + "\" not found in json object");
        }
        String value = json.getString(field);
        if (value == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return value;
    }

    public static String getStringIfDefined(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            return null;
        }
        String value = json.getString(field);
        if (value == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return value;
    }

    public static List<String> getStringListIfDefined(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            return null;
        }
        JSONArray array = json.getJSONArray(field);
        if (array == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return JsonUtil.toStringList(array);
    }

    public static Uri getUri(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        String value = json.getString(field);
        if (value == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return Uri.parse((String)value);
    }

    @Nullable
    public static Uri getUriIfDefined(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            return null;
        }
        String value = json.getString(field);
        if (value == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return Uri.parse((String)value);
    }

    @Nullable
    public static Long getLongIfDefined(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field) || json.isNull(field)) {
            return null;
        }
        try {
            return json.getLong(field);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @NonNull
    public static List<String> getStringList(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            throw new JSONException("field \"" + field + "\" not found in json object");
        }
        JSONArray array = json.getJSONArray(field);
        return JsonUtil.toStringList(array);
    }

    @NonNull
    public static List<Uri> getUriList(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            throw new JSONException("field \"" + field + "\" not found in json object");
        }
        JSONArray array = json.getJSONArray(field);
        return JsonUtil.toUriList(array);
    }

    @NonNull
    public static Map<String, String> getStringMap(JSONObject json, String field) throws JSONException {
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            return stringMap;
        }
        JSONObject mapJson = json.getJSONObject(field);
        Iterator mapKeys = mapJson.keys();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            String value = Preconditions.checkNotNull(mapJson.getString(key), "additional parameter values must not be null");
            stringMap.put(key, value);
        }
        return stringMap;
    }

    public static JSONObject getJsonObjectIfDefined(@NonNull JSONObject json, @NonNull String field) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        Preconditions.checkNotNull(field, "field must not be null");
        if (!json.has(field)) {
            return null;
        }
        JSONObject value = json.optJSONObject(field);
        if (value == null) {
            throw new JSONException("field \"" + field + "\" is mapped to a null value");
        }
        return value;
    }

    @NonNull
    public static List<String> toStringList(@Nullable JSONArray jsonArray) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                arrayList.add(Preconditions.checkNotNull(jsonArray.get(i)).toString());
            }
        }
        return arrayList;
    }

    @NonNull
    public static Map<String, Object> toMap(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = json.get(key);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @NonNull
    public static List<Object> toList(@NonNull JSONArray jsonArray) throws JSONException {
        Preconditions.checkNotNull(jsonArray, "jsonArray must not be null");
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            List<Object> value = jsonArray.get(i);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    @NonNull
    public static List<Uri> toUriList(@Nullable JSONArray jsonArray) throws JSONException {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                arrayList.add(Uri.parse((String)Preconditions.checkNotNull(jsonArray.get(i)).toString()));
            }
        }
        return arrayList;
    }

    @NonNull
    public static JSONArray toJsonArray(@NonNull Iterable<?> objects) {
        Preconditions.checkNotNull(objects, "objects cannot be null");
        JSONArray jsonArray = new JSONArray();
        for (Object obj : objects) {
            jsonArray.put((Object)obj.toString());
        }
        return jsonArray;
    }

    @NonNull
    public static JSONObject mapToJsonObject(@NonNull Map<String, String> map) {
        Preconditions.checkNotNull(map);
        JSONObject json = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), "map entries must not have null keys");
            Preconditions.checkNotNull(entry.getValue(), "map entries must not have null values");
            JsonUtil.put(json, entry.getKey(), entry.getValue());
        }
        return json;
    }

    public static <T> T get(JSONObject json, Field<T> field) {
        try {
            if (!json.has(field.key)) {
                return field.defaultValue;
            }
            return field.convert(json.getString(field.key));
        }
        catch (JSONException e) {
            throw new IllegalStateException("unexpected JSONException", e);
        }
    }

    public static <T> List<T> get(JSONObject json, ListField<T> field) {
        try {
            if (!json.has(field.key)) {
                return field.defaultValue;
            }
            Object value = json.get(field.key);
            if (!(value instanceof JSONArray)) {
                throw new IllegalStateException(field.key + " does not contain the expected JSON array");
            }
            JSONArray arrayValue = (JSONArray)value;
            ArrayList<T> values = new ArrayList<T>();
            for (int i = 0; i < arrayValue.length(); ++i) {
                values.add(field.convert(arrayValue.getString(i)));
            }
            return values;
        }
        catch (JSONException e) {
            throw new IllegalStateException("unexpected JSONException", e);
        }
    }

    static final class StringListField
    extends ListField<String> {
        StringListField(String key) {
            super(key, null);
        }

        StringListField(String key, List<String> defaultValue) {
            super(key, defaultValue);
        }

        @Override
        String convert(String value) {
            return value;
        }
    }

    static abstract class ListField<T> {
        public final String key;
        public final List<T> defaultValue;

        ListField(String key, List<T> defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        abstract T convert(String var1);
    }

    static final class BooleanField
    extends Field<Boolean> {
        BooleanField(String key, boolean defaultValue) {
            super(key, defaultValue);
        }

        @Override
        Boolean convert(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    static final class StringField
    extends Field<String> {
        StringField(String key, String defaultValue) {
            super(key, defaultValue);
        }

        StringField(String key) {
            this(key, null);
        }

        @Override
        String convert(String value) {
            return value;
        }
    }

    static final class UriField
    extends Field<Uri> {
        UriField(String key, Uri defaultValue) {
            super(key, defaultValue);
        }

        UriField(String key) {
            this(key, null);
        }

        @Override
        Uri convert(String value) {
            return Uri.parse((String)value);
        }
    }

    static abstract class Field<T> {
        public final String key;
        public final T defaultValue;

        Field(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        abstract T convert(String var1);
    }
}

