/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

public enum LineEnding {
    AUTO(System.lineSeparator()),
    KEEP(null),
    LF("\n"),
    CRLF("\r\n"),
    CR("\r"),
    UNKNOWN(null);

    private final String chars;

    private LineEnding(String value) {
        this.chars = value;
    }

    public String getChars() {
        return this.chars;
    }

    public boolean isSystem() {
        return System.lineSeparator().equals(this.getChars());
    }

    public static LineEnding determineLineEnding(String fileDataString) {
        int lfCount = 0;
        int crCount = 0;
        int crlfCount = 0;
        for (int i = 0; i < fileDataString.length(); ++i) {
            char c = fileDataString.charAt(i);
            if (c == '\r') {
                if (i + 1 < fileDataString.length() && fileDataString.charAt(i + 1) == '\n') {
                    ++crlfCount;
                    ++i;
                    continue;
                }
                ++crCount;
                continue;
            }
            if (c != '\n') continue;
            ++lfCount;
        }
        if (lfCount > crCount && lfCount > crlfCount) {
            return LF;
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return CRLF;
        }
        if (crCount > lfCount && crCount > crlfCount) {
            return CR;
        }
        return UNKNOWN;
    }
}

