/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.warbucks.maven.plugin;

import java.util.List;
import net.revelc.code.warbucks.maven.plugin.Rule;
import net.revelc.code.warbucks.maven.plugin.RuleProcessor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class CheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(alias="skip", property="warbucks.skip", defaultValue="false")
    private boolean skip;
    @Parameter(alias="ignoreRuleFailures", property="warbucks.ignoreRuleFailures", defaultValue="false")
    boolean ignoreRuleFailures;
    @Parameter(alias="processAllRules", property="warbucks.processAllRules", defaultValue="true")
    private boolean processAllRules;
    @Parameter(alias="rules", required=true)
    private List<Rule> rules;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of warbucks-maven-plugin");
            return;
        }
        if (this.rules == null || this.rules.isEmpty()) {
            this.getLog().info((CharSequence)"No rules to process");
            return;
        }
        long totalFailures = 0L;
        for (int i = 0; i < this.rules.size(); ++i) {
            if ((totalFailures += new RuleProcessor(this, this.rules.get(i), i).process()) <= 0L || this.processAllRules) continue;
            this.getLog().debug((CharSequence)"Skipping additional rules, if any, due to processAllRules=false");
            break;
        }
        this.getLog().info((CharSequence)("Total class failures: " + totalFailures));
        if (totalFailures > 0L && !this.ignoreRuleFailures) {
            throw new MojoFailureException("There were rule failures. See the output above for details.");
        }
    }
}

