/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.serenitybdd.core.history.FileSystemTestOutcomeSummaryRecorder;
import net.serenitybdd.core.history.TestOutcomeSummaryRecorder;
import net.serenitybdd.maven.plugins.MavenProjectHelper;
import net.serenitybdd.maven.plugins.UpdatedClassLoader;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="history", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SerenityHistoryMojo
extends AbstractMojo {
    private static final String DEFAULT_HISTORY_DIRECTORY = "history";
    @Parameter(property="serenity.outputDirectory")
    public String outcomesDirectoryPath;
    @Parameter(property="serenity.historyDirectory")
    public String historyDirectoryPath;
    @Parameter(property="serenity.deletePreviousHistory")
    public Boolean deletePreviousHistory = false;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project}")
    public MavenProject project;

    protected TestOutcomeSummaryRecorder getTestOutcomeSummaryRecorder() {
        MavenProjectHelper.propagateBuildDir(this.session);
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        String configuredHistoryDirectoryPath = ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY.from(environmentVariables, Optional.ofNullable(this.historyDirectoryPath).orElse(DEFAULT_HISTORY_DIRECTORY));
        Path historyDirectory = Paths.get(configuredHistoryDirectoryPath, new String[0]);
        return new FileSystemTestOutcomeSummaryRecorder(historyDirectory, this.deletePreviousHistory);
    }

    private Path outputDirectory() {
        return !StringUtils.isEmpty((CharSequence)this.outcomesDirectoryPath) ? this.session.getCurrentProject().getBasedir().toPath().resolve(this.outcomesDirectoryPath).toAbsolutePath() : this.getConfiguration().getOutputDirectory().toPath();
    }

    private Configuration getConfiguration() {
        return (Configuration)Injectors.getInjector().getProvider(Configuration.class).get();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Storing Serenity test result summaries");
        UpdatedClassLoader.withProjectClassesFrom(this.project);
        this.getTestOutcomeSummaryRecorder().recordOutcomeSummariesFrom(this.outputDirectory());
    }
}

