/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import java.util.List;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SystemPropertiesConfiguration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverManager;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public final class TestCaseAnnotations {
    private final Object testCase;
    private final Configuration configuration;

    public TestCaseAnnotations(Object testCase, SystemPropertiesConfiguration configuration) {
        this.testCase = testCase;
        this.configuration = configuration;
    }

    public TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
        this.configuration = ConfiguredEnvironment.getConfiguration();
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        Optional<ManagedWebDriverAnnotatedField> webDriverField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(this.testCase.getClass());
        if (webDriverField.isPresent()) {
            ((ManagedWebDriverAnnotatedField)webDriverField.get()).setValue(this.testCase, driver);
        }
    }

    public void injectDrivers(WebdriverManager webdriverManager) {
        this.injectDrivers(ThucydidesWebDriverSupport.getDriver(), webdriverManager);
    }

    public void injectDrivers(WebDriver defaultDriver, WebdriverManager webdriverManager) {
        List<ManagedWebDriverAnnotatedField> webDriverFields = ManagedWebDriverAnnotatedField.findAnnotatedFields(this.testCase.getClass());
        int driverCount = 1;
        String suffix = "";
        for (ManagedWebDriverAnnotatedField webDriverField : webDriverFields) {
            String driverRootName = StringUtils.isNotEmpty((CharSequence)webDriverField.getDriver()) ? webDriverField.getDriver() : this.configuredDriverType();
            String driverName = driverRootName + suffix;
            WebDriver driver = StringUtils.isEmpty((CharSequence)driverName) ? defaultDriver : webdriverManager.getWebdriver(driverName);
            webDriverField.setValue(this.testCase, driver);
            suffix = this.nextSuffix(driverCount++);
        }
    }

    private String configuredDriverType() {
        if (ThucydidesWebDriverSupport.isInitialised()) {
            return ThucydidesWebDriverSupport.getCurrentDriverName();
        }
        return this.configuration.getDriverType().name();
    }

    private String nextSuffix(int driverCount) {
        return String.format(":%d", driverCount + 1);
    }

    public static boolean supportsWebTests(Class clazz) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(clazz);
    }

    public boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession(this.testCase.getClass());
    }

    public static boolean isUniqueSession(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.isUniqueSession();
    }

    public static boolean isWebTest(Class<?> testClass) {
        return ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass).isPresent();
    }

    public static boolean shouldClearCookiesBeforeEachTestIn(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.getClearCookiesPolicy() == ClearCookiesPolicy.BeforeEachTest;
    }
}

