/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementDescriber;
import net.thucydides.core.annotations.NotImplementedException;
import net.thucydides.core.annotations.locators.WebElementFacadeImplLocator;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class AbstractSingleItemHandler<T>
implements InvocationHandler {
    protected final ElementLocator locator;
    protected final PageObject page;
    protected final Class<?> implementerClass;

    public AbstractSingleItemHandler(Class<T> targetInterface, Class<?> interfaceType, ElementLocator locator, PageObject page) {
        this.page = page;
        this.locator = locator;
        if (!targetInterface.isAssignableFrom(interfaceType)) {
            throw new NotImplementedException("interface not assignable to " + targetInterface.getSimpleName());
        }
        this.implementerClass = new WebElementFacadeImplLocator().getImplementer(interfaceType);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        try {
            if ("getWrappedElement".equals(method.getName())) {
                return this.locator.findElement();
            }
            if ("toString".equals(method.getName())) {
                return this.toStringForElement();
            }
            Object webElementFacadeExt = this.newElementInstance();
            return method.invoke(this.implementerClass.cast(webElementFacadeExt), objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected abstract Object newElementInstance() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    private String toStringForElement() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object webElementFacadeExt = this.newElementInstance();
        if (webElementFacadeExt == null) {
            return "<" + this.locator.toString() + ">";
        }
        return new WebElementDescriber().webElementDescription((WebElement)webElementFacadeExt, this.locator);
    }
}

