/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.NameConverter;

public class ReportNamer {
    private ReportType type;
    private boolean compressedFilename = true;

    public static ReportNamer forReportType(ReportType type) {
        return new ReportNamer(type);
    }

    private ReportNamer(ReportType type) {
        this(type, ConfiguredEnvironment.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.SERENITY_COMPRESS_FILENAMES.getPropertyName(), true));
    }

    public ReportNamer(ReportType type, boolean compressedFilename) {
        this.type = type;
        this.compressedFilename = compressedFilename;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = this.getBaseTestNameFor(testOutcome);
        String testNameWithoutIndex = NameConverter.stripIndexesFrom(testName);
        return this.normalizedVersionOf(NameConverter.filesystemSafe(testNameWithoutIndex));
    }

    private String optionallyCompressed(String text) {
        return this.compressedFilename ? Digest.ofTextValue(text) : text;
    }

    private String getBaseTestNameFor(TestOutcome testOutcome) {
        return NameConverter.withNoIssueNumbers(testOutcome.getQualifiedId());
    }

    public String getSimpleTestNameFor(TestOutcome testOutcome) {
        return this.optionallyCompressed(this.appendSuffixTo(NameConverter.withNoIssueNumbers(testOutcome.getQualifiedId())));
    }

    public String getNormalizedTestNameFor(Story userStory) {
        return this.getNormalizedTestNameFor(userStory.getName());
    }

    public String getNormalizedTestNameFor(String name) {
        return this.normalizedVersionOf(NameConverter.underscore(name.toLowerCase()));
    }

    private String normalizedVersionOf(String text) {
        return this.compressedFilename ? this.appendSuffixTo(Digest.ofTextValue(text)) : this.appendSuffixTo(text);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    public ReportNamer withNoCompression() {
        return new ReportNamer(this.type, false);
    }
}

