/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.reports;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import net.serenitybdd.core.reports.AndContent;
import net.serenitybdd.core.reports.WithTitle;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.ReportData;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.StepEventBus;

public class ReportDataSaver
implements WithTitle,
AndContent {
    private final StepEventBus eventBus;
    private String title;

    public ReportDataSaver(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public AndContent withTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public void andContents(String contents) {
        this.eventBus.getBaseStepListener().latestTestOutcome().ifPresent(outcome -> outcome.currentStep().withReportData(ReportData.withTitle((String)this.title).andContents(contents)));
    }

    @Override
    public void fromFile(Path source) throws IOException {
        Charset encoding = Charset.forName(ThucydidesSystemProperty.SERENITY_REPORT_ENCODING.from(this.eventBus.getEnvironmentVariables(), StandardCharsets.UTF_8.name()));
        this.fromFile(source, encoding);
    }

    @Override
    public void fromFile(Path source, Charset encoding) throws IOException {
        Optional<TestOutcome> outcome = this.eventBus.getBaseStepListener().latestTestOutcome();
        if (outcome.isPresent()) {
            outcome.get().currentStep().withReportData(ReportData.withTitle((String)this.title).fromFile(source, encoding));
        }
    }
}

