/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.webdriver.DriverName;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

public class WebdriverInstances {
    private final Map<String, WebDriver> driverMap = new HashMap<String, WebDriver>();
    private final ThreadLocal<Set<String>> driversUsedInCurrentThread = new ThreadLocal();
    private final DriverName driverNamer;
    private String currentDriver;

    public WebdriverInstances() {
        this.driversUsedInCurrentThread.set(new HashSet());
        this.driverNamer = new DriverName(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public WebDriver getCurrentDriver() {
        if (this.driverMap.containsKey(this.currentDriver)) {
            return this.driverMap.get(this.currentDriver);
        }
        return null;
    }

    public String getCurrentDriverName() {
        return this.currentDriver == null ? "" : this.currentDriver;
    }

    public String getCurrentDriverType() {
        if (this.getCurrentDriver() == null) {
            return "";
        }
        if (this.getCurrentDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getCurrentDriver()).getDriverName();
        }
        if (this.currentDriverIsMocked()) {
            return this.currentMockedDriverType();
        }
        return "";
    }

    private boolean currentDriverIsMocked() {
        return this.getCurrentDriver().getClass().getName().contains("Mockito");
    }

    private String currentMockedDriverType() {
        String className = this.getCurrentDriver().getClass().getName();
        if (className.contains("WebDriver")) {
            return "firefox";
        }
        return SupportedWebDriver.forClass(this.getCurrentDriver().getClass().getSuperclass()).name().toLowerCase();
    }

    public WebDriver closeCurrentDriver() {
        WebDriver closedDriver = null;
        if (this.getCurrentDriver() != null) {
            closedDriver = this.getCurrentDriver();
            this.closeAndQuit(closedDriver);
            this.currentDriver = null;
        }
        return closedDriver;
    }

    private void closeAndQuit(WebDriver driver) {
        driver.quit();
    }

    public void resetCurrentDriver() {
        WebDriver driver;
        if (this.getCurrentDriver() != null && WebDriverFacade.class.isAssignableFrom((driver = this.getCurrentDriver()).getClass())) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public boolean driverIsRegisteredFor(String driverName) {
        return this.driverMap.containsKey(this.driverNamer.normalisedFormOf(driverName));
    }

    public WebDriver useDriver(String driverName) {
        this.driversUsedInCurrentThread.get().add(this.driverNamer.normalisedFormOf(driverName));
        return this.driverMap.get(this.driverNamer.normalisedFormOf(driverName));
    }

    public Set<WebDriver> closeAllDrivers() {
        Collection<WebDriver> openDrivers = this.driverMap.values();
        HashSet<WebDriver> closedDrivers = new HashSet<WebDriver>(openDrivers);
        for (WebDriver driver : openDrivers) {
            this.closeAndQuit(driver);
        }
        this.driverMap.clear();
        this.clearDriversInCurrentThread();
        this.currentDriver = null;
        return closedDrivers;
    }

    private void clearDriversInCurrentThread() {
        this.driversUsedInCurrentThread.get().clear();
    }

    public void closeCurrentDrivers() {
        this.closeCurrentDriver();
        for (String driverName : this.driversUsedInCurrentThread.get()) {
            WebDriver openDriver = this.driverMap.get(driverName);
            if (!this.isInstantiated(openDriver)) continue;
            this.closeAndQuit(openDriver);
        }
        this.currentDriver = null;
    }

    public int getActiveWebdriverCount() {
        return this.driverMap.size();
    }

    public boolean hasAnInstantiatedDriver() {
        for (WebDriver driver : this.driverMap.values()) {
            if (!this.isInstantiated(driver)) continue;
            return true;
        }
        return false;
    }

    private boolean isInstantiated(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).isInstantiated();
        }
        return driver != null;
    }

    public void setCurrentDriverTo(WebDriver driver) {
        if (this.registeredDriverNameFor(driver) == null) {
            ThucydidesWebDriverSupport.initialize();
            ThucydidesWebDriverSupport.getWebdriverManager().registerDriver(driver);
        }
        this.currentDriver = this.driverNameFor(driver);
    }

    private String registeredDriverNameFor(WebDriver driver) {
        for (String driverName : this.driverMap.keySet()) {
            WebDriver mappedDriver = this.driverMap.get(driverName);
            if (!this.matchingDriver(mappedDriver, driver)) continue;
            return driverName;
        }
        return null;
    }

    private String driverNameFor(WebDriver driver) {
        String driverName = this.registeredDriverNameFor(driver);
        if (driverName == null) {
            throw new IllegalStateException("No matching driver found for " + driverName + " in this thread");
        }
        return driverName;
    }

    private boolean matchingDriver(WebDriver mappedDriver, WebDriver driver) {
        if (mappedDriver == driver) {
            return true;
        }
        return driver instanceof WebDriverFacade && mappedDriver == ((WebDriverFacade)driver).proxiedWebDriver;
    }

    public List<WebDriver> getActiveDrivers() {
        ArrayList<WebDriver> activeDrivers = new ArrayList<WebDriver>();
        for (WebDriver webDriver : this.driverMap.values()) {
            if (!(webDriver instanceof WebDriverFacade)) {
                activeDrivers.add(webDriver);
                continue;
            }
            if (!((WebDriverFacade)webDriver).isInstantiated()) continue;
            activeDrivers.add(webDriver);
        }
        return activeDrivers;
    }

    public List<String> getActiveDriverTypes() {
        ArrayList<String> activeDrivers = new ArrayList<String>();
        for (WebDriver webDriver : this.driverMap.values()) {
            if (!(webDriver instanceof WebDriverFacade)) {
                activeDrivers.add(this.driverNameFor(webDriver));
                continue;
            }
            if (!((WebDriverFacade)webDriver).isInstantiated()) continue;
            activeDrivers.add(this.driverNameFor(webDriver));
        }
        return activeDrivers;
    }

    public InstanceRegistration registerDriverCalled(String driverName) {
        return new InstanceRegistration(this.driverNamer.normalisedFormOf(driverName));
    }

    public final class InstanceRegistration {
        private final String driverName;

        public InstanceRegistration(String driverName) {
            this.driverName = WebdriverInstances.this.driverNamer.normalisedFormOf(driverName);
        }

        public void forDriver(WebDriver driver) {
            if (!WebdriverInstances.this.driverMap.values().contains(driver)) {
                WebdriverInstances.this.driverMap.put(this.driverName, driver);
            }
        }
    }
}

