/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.redimension;

import io.appium.java_client.AppiumDriver;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

class RedimensionConfiguration {
    private final EnvironmentVariables environmentVariables;

    RedimensionConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean supportsScreenResizing(WebDriver driver) {
        return this.supportsResizing(driver.getClass()) && this.isNotAMocked(driver);
    }

    public boolean isBrowserDimensionsSpecified() {
        return this.getWidth() > 0 || this.getHeight() > 0;
    }

    public boolean isBrowserMaximised() {
        return ThucydidesSystemProperty.SERENITY_BROWSER_MAXIMIZED.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    public boolean supportsResizing(Class<? extends WebDriver> driverClass) {
        return !AppiumDriver.class.isAssignableFrom(driverClass) && !HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock") && !driver.toString().contains("Mock for");
    }

    public int getWidth() {
        return ThucydidesSystemProperty.THUCYDIDES_BROWSER_WIDTH.integerFrom(this.environmentVariables, 0);
    }

    public int getHeight() {
        return ThucydidesSystemProperty.THUCYDIDES_BROWSER_HEIGHT.integerFrom(this.environmentVariables, 0);
    }

    public boolean isDisabled() {
        return ThucydidesSystemProperty.SERENITY_BROWSER_RESIZING.booleanFrom(this.environmentVariables, Boolean.valueOf(true)) == false;
    }
}

