/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.serenitybdd.core.pages.PageLooksDodgyException;
import net.serenitybdd.core.pages.PageObject;
import org.openqa.selenium.WebDriver;

public class PageObjects {
    public static final String NO_WEBDRIVER_CONSTRUCTOR_MESSAGE = "This page object does not appear have a constructor that takes a WebDriver parameter";
    private final WebDriver driver;

    public PageObjects(WebDriver driver) {
        this.driver = driver;
    }

    public static PageObjects usingDriver(WebDriver driver) {
        return new PageObjects(driver);
    }

    public <T extends PageObject> T ofType(Class<T> pageObjectClass) {
        try {
            Optional<T> simplePageObject = this.newPageObjectWithSimpleConstructor(pageObjectClass);
            return (T)(simplePageObject.isPresent() ? (PageObject)simplePageObject.get() : this.newPageObjectWithDriver(pageObjectClass));
        }
        catch (Throwable somethingWentWrong) {
            throw this.pageLooksDodgyExceptionBasedOn(somethingWentWrong, pageObjectClass);
        }
    }

    private <T extends PageObject> PageLooksDodgyException pageLooksDodgyExceptionBasedOn(Throwable somethingWentWrong, Class<T> pageObjectClass) {
        if (somethingWentWrong instanceof NoSuchMethodException) {
            return this.thisPageObjectLooksDodgy(pageObjectClass, NO_WEBDRIVER_CONSTRUCTOR_MESSAGE, somethingWentWrong);
        }
        if (somethingWentWrong instanceof InvocationTargetException) {
            return this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page", ((InvocationTargetException)somethingWentWrong).getTargetException());
        }
        return this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page", somethingWentWrong);
    }

    private <T extends PageObject> Optional<T> newPageObjectWithSimpleConstructor(Class<T> pageObjectClass) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        try {
            Class[] constructorArgs = new Class[]{};
            Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
            PageObject newPage = (PageObject)constructor.newInstance(new Object[0]);
            newPage.setDriver(this.driver);
            return Optional.of(newPage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Optional.empty();
        }
    }

    private <T extends PageObject> T newPageObjectWithDriver(Class<T> pageObjectClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class[] constructorArgs = new Class[]{WebDriver.class};
        Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
        return (T)((PageObject)constructor.newInstance(this.driver));
    }

    private PageLooksDodgyException thisPageObjectLooksDodgy(Class<? extends PageObject> pageObjectClass, String message, Throwable e) {
        return new PageLooksDodgyException("The page object " + pageObjectClass + " looks dodgy:\n" + message, e);
    }
}

