/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.configuration;

import java.util.Arrays;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RestartBrowserForEach {
    NEVER(0),
    FEATURE(1),
    STORY(1),
    SCENARIO(2),
    EXAMPLE(3);

    private static final Logger LOGGER;
    private final int order;

    private RestartBrowserForEach(int order) {
        this.order = order;
    }

    public boolean restartBrowserForANew(RestartBrowserForEach restartLevel) {
        return this.order >= restartLevel.order;
    }

    public static RestartBrowserForEach configuredIn(EnvironmentVariables environmentVariables) {
        String configuredLevel = ThucydidesSystemProperty.SERENITY_RESTART_BROWSER_FOR_EACH.from(environmentVariables, EXAMPLE.name()).toUpperCase();
        try {
            return RestartBrowserForEach.valueOf(configuredLevel);
        }
        catch (IllegalArgumentException invalidConfiguredValue) {
            LOGGER.warn("Invalid value `{}` for restart.browser.for.each: should be one of {}", (Object)configuredLevel, (Object)Arrays.toString((Object[])RestartBrowserForEach.values()));
            return EXAMPLE;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(RestartBrowserForEach.class);
    }
}

