/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import com.google.inject.Inject;
import net.thucydides.core.configuration.SystemPropertiesConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;

public class WebDriverConfiguration<T extends DriverConfiguration>
extends SystemPropertiesConfiguration
implements DriverConfiguration {
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";

    @Inject
    public WebDriverConfiguration(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
    }

    @Override
    public SupportedWebDriver getDriverType() {
        String driverType = WebDriverFactory.getDriverFrom(this.getEnvironmentVariables(), DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }

    public WebDriverConfiguration copy() {
        return this.withEnvironmentVariables(this.getEnvironmentVariables());
    }

    public WebDriverConfiguration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        WebDriverConfiguration<T> copy = new WebDriverConfiguration<T>(environmentVariables.copy());
        copy.outputDirectory = null;
        copy.defaultBaseUrl = this.defaultBaseUrl;
        return copy;
    }
}

