/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.construction;

import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import net.serenitybdd.core.collect.NewSet;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;

public class StepLibraryType {
    private final Class<?> stepLibraryClass;

    public StepLibraryType(Class<?> stepLibraryClass) {
        this.stepLibraryClass = stepLibraryClass;
    }

    public static StepLibraryType ofClass(Class<?> stepLibraryClass) {
        return new StepLibraryType(stepLibraryClass);
    }

    public <T> boolean hasAPagesConstructor() {
        Set constructors = NewSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return constructors.stream().anyMatch(this.withASinglePagesParameter());
    }

    public <T> boolean hasAConstructorWithParameters() {
        Set constructors = NewSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return constructors.stream().anyMatch(this.withAnyParameters());
    }

    public <T> boolean hasAPagesField() {
        Set fields = NewSet.copyOf((Collection)Fields.of(this.stepLibraryClass).allFields());
        return fields.stream().anyMatch(StepLibraryType.ofTypePages());
    }

    private Predicate<Constructor<?>> withAnyParameters() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length > 0;
            }

            public boolean test(Constructor<?> input) {
                return this.apply(input);
            }
        };
    }

    private Predicate<Constructor<?>> withASinglePagesParameter() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
            }

            public boolean test(Constructor<?> input) {
                return this.apply(input);
            }
        };
    }

    public static Predicate<Field> ofTypePages() {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return input.getType() == Pages.class;
            }

            public boolean test(Field input) {
                return this.apply(input);
            }
        };
    }
}

