/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.appium;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PathProcessor;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.OptionsMap;
import net.thucydides.core.webdriver.ThucydidesConfigurationException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppiumConfiguration.class);
    private static final String DEFAULT_URL = "http://127.0.0.1:4723/wd/hub";
    private final EnvironmentVariables environmentVariables;

    private AppiumConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static AppiumConfiguration from(EnvironmentVariables environmentVariables) {
        return new AppiumConfiguration(environmentVariables);
    }

    public MobilePlatform getTargetPlatform(WebDriver driver) {
        String PLATFORM_NAME = "platformName";
        try {
            Capabilities caps = RemoteDriver.of(driver).getCapabilities();
            if (caps.getCapabilityNames().contains(PLATFORM_NAME)) {
                return MobilePlatform.valueOf(caps.getCapability(PLATFORM_NAME).toString().toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Platform was not a MobilePlatform. Falling back to other platform definitions.");
        }
        catch (ClassCastException e) {
            LOGGER.debug("The driver could not be cast to RemoteWebDriver. Falling back to other platform definitions.");
        }
        return this.getTargetPlatform();
    }

    public MobilePlatform getTargetPlatform() {
        Optional<MobilePlatform> contextPlatform = Stream.of(this.definedContext()).filter(platform -> platform.isDefined).findFirst();
        if (contextPlatform.isPresent()) {
            return contextPlatform.get();
        }
        return Stream.of(this.definedTargetPlatform()).filter(platform -> platform.isDefined).findFirst().orElseThrow(() -> new ThucydidesConfigurationException("The appium.platformName needs to be specified (either IOS or ANDROID)"));
    }

    public MobilePlatform definedTargetPlatform() {
        String targetPlatform = this.environmentVariables.getProperty("appium.platformName", "NONE");
        try {
            return MobilePlatform.valueOf(targetPlatform.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ThucydidesConfigurationException("Illegal appium.platformName value (needs to be either IOS or ANDROID):" + targetPlatform);
        }
    }

    public MobilePlatform definedContext() {
        String targetPlatform = this.environmentVariables.getProperty("context", "NONE");
        try {
            return MobilePlatform.valueOf(targetPlatform.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("The provided context ({}) could not be used as the MobilePlatform", (Object)targetPlatform);
            return MobilePlatform.NONE;
        }
    }

    public URL getUrl() {
        String url = this.environmentVariables.getProperty("appium.hub", DEFAULT_URL);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ThucydidesConfigurationException("The appium.hub URL needs to be specified");
        }
    }

    public DesiredCapabilities getCapabilities() {
        return this.getCapabilities("");
    }

    public DesiredCapabilities getCapabilities(String options) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Properties appiumProperties = this.getProperties(options);
        for (Object key : appiumProperties.keySet()) {
            capabilities.setCapability(key.toString(), appiumProperties.getProperty(key.toString()));
            capabilities.asMap();
        }
        return capabilities;
    }

    public Properties getProperties(String options) {
        return this.appiumPropertiesFrom(this.environmentVariables, options);
    }

    private Properties appiumPropertiesFrom(EnvironmentVariables environmentVariables, String options) {
        Properties appiumProperties = new Properties();
        List appiumKeys = environmentVariables.getKeys().stream().filter(key -> key.startsWith("appium.")).collect(Collectors.toList());
        for (String key2 : appiumKeys) {
            String value = this.isAppProperty(key2) ? this.appPathFrom(environmentVariables.getProperty(key2)) : environmentVariables.getProperty(key2);
            String simplifiedKey = key2.replace("appium.", "");
            appiumProperties.setProperty(simplifiedKey, value.trim());
        }
        Map<String, String> optionsMap = OptionsMap.from(options);
        for (String key3 : optionsMap.keySet()) {
            appiumProperties.setProperty(key3, optionsMap.get(key3));
        }
        this.ensureAppOrBrowserPathDefinedIn(appiumProperties);
        return appiumProperties;
    }

    private void ensureAppOrBrowserPathDefinedIn(Properties appiumProperties) {
        if (!appiumProperties.containsKey("app") && !appiumProperties.containsKey("browserName")) {
            throw new ThucydidesConfigurationException("The browser under test or path to the app needs to be provided in the appium.app or appium.browserName property.");
        }
    }

    private String appPathFrom(String propertyValue) {
        return new PathProcessor().normalize(propertyValue);
    }

    private boolean isAppProperty(String key) {
        return key.equals("appium.app");
    }

    public boolean isDefined() {
        return this.getTargetPlatform() != MobilePlatform.NONE;
    }
}

