/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.lang.reflect.Method;
import java.util.Optional;
import net.thucydides.core.util.NameConverter;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

class RemoteTestName {
    RemoteTestName() {
    }

    public static Optional<String> fromCurrentTest() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (RemoteTestName.isATestMethod(callingMethod)) {
                    return Optional.of(NameConverter.humanize((String)elt.getMethodName()));
                }
                if (!RemoteTestName.isASetupMethod(callingMethod)) continue;
                return Optional.of(NameConverter.humanize((String)callingClass.getSimpleName()));
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static boolean isATestMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Test.class) != null;
    }

    private static boolean isASetupMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Before.class) != null || callingMethod.getAnnotation(BeforeClass.class) != null;
    }
}

