/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.ConfiguredProxy;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.ChromePreferences;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverCapabilities
implements DriverCapabilitiesProvider {
    private static final List<String> AUTOMATION_OPTIONS = Arrays.asList("--enable-automation", "--test-type");
    private final EnvironmentVariables environmentVariables;
    private final String driverOptions;

    public ChromeDriverCapabilities(EnvironmentVariables environmentVariables, String driverOptions) {
        this.environmentVariables = environmentVariables;
        this.driverOptions = driverOptions;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        ChromeOptions chromeOptions = this.configuredOptions();
        capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
        String chromeSwitches = ThucydidesSystemProperty.CHROME_SWITCHES.from(this.environmentVariables);
        capabilities.setCapability("chrome.switches", chromeSwitches);
        AddCustomCapabilities.startingWith("chrome.capabilities.").from(this.environmentVariables).to(capabilities);
        AddLoggingPreferences.from(this.environmentVariables).to(capabilities);
        SetProxyConfiguration.from(this.environmentVariables).in(capabilities);
        return capabilities;
    }

    public ChromeOptions configuredOptions() {
        ChromeOptions options = new ChromeOptions();
        if (ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY.isDefinedIn(this.environmentVariables)) {
            options.setBinary(ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY.from(this.environmentVariables));
        }
        this.addEnvironmentSwitchesTo(options);
        this.addRuntimeOptionsTo(options);
        this.addPreferencesTo(options);
        this.addExperimentalOptionsTo(options);
        this.updateChromeBinaryIfSpecified(options);
        this.addProxyConfigurationTo(options);
        this.addPageLoadStrategyTo(options);
        this.addExtensionsTo(options);
        this.addUnhandledPromptBehaviour(options);
        return options;
    }

    private void addExtensionsTo(ChromeOptions options) {
        ThucydidesSystemProperty.CHROME_EXTENSION.optionalFrom(this.environmentVariables).ifPresent(extensionFile -> options.addExtensions(new File[]{new File((String)extensionFile)}));
    }

    private void addUnhandledPromptBehaviour(ChromeOptions options) {
        String unexpectedAlertBehavior = ThucydidesSystemProperty.SERENITY_DRIVER_UNEXPECTED_ALERT_BEHAVIOUR.from(this.environmentVariables);
        if (unexpectedAlertBehavior != null) {
            options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.fromString((String)unexpectedAlertBehavior));
        }
    }

    private void addPageLoadStrategyTo(ChromeOptions options) {
        String pageLoadStrategy = ThucydidesSystemProperty.SERENITY_DRIVER_PAGE_LOAD_STRATEGY.from(this.environmentVariables);
        if (pageLoadStrategy != null) {
            options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
        }
    }

    private void addProxyConfigurationTo(ChromeOptions options) {
        ConfiguredProxy.definedIn(this.environmentVariables).ifPresent(arg_0 -> ((ChromeOptions)options).setProxy(arg_0));
    }

    private void addEnvironmentSwitchesTo(ChromeOptions options) {
        String chromeSwitches = ThucydidesSystemProperty.CHROME_SWITCHES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            List<String> arguments = new OptionsSplitter().split(chromeSwitches);
            options.addArguments(arguments);
        }
        if (ThucydidesSystemProperty.HEADLESS_MODE.isDefinedIn(this.environmentVariables) && ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            options.addArguments(new String[]{"--headless"});
        }
    }

    private void addRuntimeOptionsTo(ChromeOptions options) {
        if (ThucydidesSystemProperty.USE_CHROME_AUTOMATION_OPTIONS.booleanFrom(this.environmentVariables, Boolean.valueOf(true)).booleanValue()) {
            options.addArguments(AUTOMATION_OPTIONS);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.driverOptions)) {
            List<String> arguments = new OptionsSplitter().split(this.driverOptions);
            options.addArguments(arguments);
        }
        options.setAcceptInsecureCerts(ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue());
    }

    private void addPreferencesTo(ChromeOptions options) {
        Map<String, Object> chromePreferences = ChromePreferences.startingWith("chrome_preferences.").from(this.environmentVariables);
        chromePreferences.putAll(ChromePreferences.startingWith("chrome.preferences.").from(this.environmentVariables));
        if (!chromePreferences.isEmpty()) {
            options.setExperimentalOption("prefs", chromePreferences);
        }
    }

    private void addExperimentalOptionsTo(ChromeOptions options) {
        Map<String, Object> chrome_experimental_options = ChromePreferences.startingWith("chrome_experimental_options.").from(this.environmentVariables);
        Map<String, Object> nestedExperimentalOptions = ChromePreferences.startingWith("chrome.experimental_options.").from(this.environmentVariables);
        chrome_experimental_options.putAll(nestedExperimentalOptions);
        chrome_experimental_options.keySet().forEach(key -> options.setExperimentalOption(key, chrome_experimental_options.get(key)));
    }

    private void updateChromeBinaryIfSpecified(ChromeOptions options) {
        File executable = DriverServiceExecutable.called("chromedriver").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://sites.google.com/a/chromium.org/chromedriver/downloads").asAFile();
        if (executable != null && executable.exists()) {
            System.setProperty("webdriver.chrome.driver", executable.getAbsolutePath());
        }
    }
}

