/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.serenitybdd.core.CurrentOS;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTemporaryFolder
extends ExternalResource {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedTemporaryFolder.class);
    private final File parentFolder;
    private File folder;

    public ExtendedTemporaryFolder() {
        this(null);
    }

    public ExtendedTemporaryFolder(File parentFolder) {
        this.parentFolder = parentFolder;
    }

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.delete();
    }

    public void create() throws IOException {
        this.folder = this.createTemporaryFolderIn(this.parentFolder);
    }

    public File newFile() throws IOException {
        return File.createTempFile("junit", null, this.getRoot());
    }

    public File newFolder(String folder) throws IOException {
        return this.newFolder(new String[]{folder});
    }

    public File newFolder(String ... folderNames) throws IOException {
        File file = this.getRoot();
        for (int i = 0; i < folderNames.length; ++i) {
            String folderName = folderNames[i];
            if ((file = new File(file, folderName)).mkdir() || !this.isLastElementInArray(i, folderNames)) continue;
            throw new IOException("a folder with the name '" + folderName + "' already exists");
        }
        return file;
    }

    private boolean isLastElementInArray(int index, String[] array) {
        return index == array.length - 1;
    }

    private File createTemporaryFolderIn(File parentFolder) throws IOException {
        return parentFolder != null ? Files.createTempDirectory(parentFolder.toPath(), "junit", new FileAttribute[0]).toFile() : Files.createTempDirectory("junit", new FileAttribute[0]).toFile();
    }

    public File getRoot() {
        if (this.folder == null) {
            throw new IllegalStateException("the temporary folder has not yet been created");
        }
        return this.folder;
    }

    public void delete() {
        if (this.folder != null) {
            this.recursiveDelete(this.folder);
        }
    }

    private void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                this.recursiveDelete(each);
            }
        }
        file.delete();
    }

    public File newFolder() throws IOException {
        if (CurrentOS.isWindows()) {
            ExtendedTemporaryFolder extendedTemporaryFolder = this;
            synchronized (extendedTemporaryFolder) {
                try {
                    return this.createTemporaryFolderIn(this.getRoot());
                }
                catch (IOException e) {
                    logger.debug("Error when invoke newFolder(): {}", (Throwable)e);
                    throw e;
                }
            }
        }
        return this.createTemporaryFolderIn(this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File newFile(String fileName) throws IOException {
        if (CurrentOS.isWindows()) {
            ExtendedTemporaryFolder extendedTemporaryFolder = this;
            synchronized (extendedTemporaryFolder) {
                File file = new File(this.getRoot(), fileName);
                file.setWritable(true);
                file.setReadable(true);
                file.createNewFile();
                return file;
            }
        }
        File file = new File(this.getRoot(), fileName);
        file.createNewFile();
        return file;
    }
}

