/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.TableRow;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LineFilters {
    private final Map<URI, Set<Integer>> lineFilters = this.newLineFilters();

    public static LineFilters forCurrentContext() {
        return new LineFilters();
    }

    public Optional<URI> getURIForFeaturePath(URI featurePath) {
        return this.lineFilters.keySet().stream().filter(uri -> featurePath.equals(uri)).findFirst();
    }

    private Map<URI, Set<Integer>> newLineFilters() {
        RuntimeOptions runtimeOptions = RuntimeOptions.defaultOptions();
        Map lineFiltersFromRuntime = runtimeOptions.getLineFilters();
        if (lineFiltersFromRuntime == null) {
            return new HashMap<URI, Set<Integer>>();
        }
        return lineFiltersFromRuntime;
    }

    public Set<Integer> getLineNumbersFor(URI featurePath) {
        return this.lineFilters.get(featurePath);
    }

    public boolean examplesAreNotExcluded(Examples examples, URI featurePath) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (this.lineFiltersContainFeaturePath(featurePath)) {
            Optional<URI> uriForFeaturePath = this.getURIForFeaturePath(featurePath);
            return uriForFeaturePath.filter(uri -> examples.getTableBody().stream().anyMatch(row -> this.lineFilters.get(uri).contains(Math.toIntExact(row.getLocation().getLine())))).isPresent();
        }
        return false;
    }

    public boolean tableRowIsNotExcludedBy(TableRow tableRow, URI featurePath) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (this.lineFiltersContainFeaturePath(featurePath)) {
            Optional<URI> uriForFeaturePath = this.getURIForFeaturePath(featurePath);
            return uriForFeaturePath.filter(uri -> this.lineFilters.get(uri).contains(Math.toIntExact(tableRow.getLocation().getLine()))).isPresent();
        }
        return false;
    }

    private boolean lineFiltersContainFeaturePath(URI featurePath) {
        return this.getURIForFeaturePath(featurePath) != null;
    }
}

