/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.service;

import java.util.Arrays;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.statistics.service.ContextTagProvider;
import net.thucydides.model.statistics.service.InjectedTagProvider;
import net.thucydides.model.statistics.service.TagProvider;
import net.thucydides.model.statistics.service.TagProviderStrategy;
import net.thucydides.model.steps.TestSourceType;
import net.thucydides.model.util.EnvironmentVariables;

public class CucumberTagProviderStrategy
implements TagProviderStrategy {
    private final EnvironmentVariables environmentVariables;

    public CucumberTagProviderStrategy(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public CucumberTagProviderStrategy() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public boolean canHandleTestSource(String testType) {
        return TestSourceType.TEST_SOURCE_CUCUMBER.getValue().equalsIgnoreCase(testType);
    }

    public Iterable<? extends TagProvider> getTagProviders() {
        return Arrays.asList(new FileSystemRequirementsTagProvider(this.environmentVariables), new InjectedTagProvider(this.environmentVariables), new ContextTagProvider());
    }

    public boolean hasHighPriority() {
        return false;
    }
}

