/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.TaggedScenario;
import io.cucumber.messages.types.Tag;
import java.net.URI;
import java.util.List;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.TestResult;

public class ScenarioTagProcessor {
    public static TestResult processScenarioTags(List<Tag> tags, URI scenarioUri) {
        StepEventBus eventBus = StepEventBus.eventBusFor((Object)scenarioUri);
        if (TaggedScenario.isManual(tags)) {
            eventBus.testIsManual();
            eventBus.enableDryRun();
            TestResult manualResult = TestResult.SUCCESS;
            if (TaggedScenario.manualResultDefinedIn(tags).isPresent()) {
                manualResult = TaggedScenario.manualResultDefinedIn(tags).get();
                eventBus.getBaseStepListener().recordManualTestResult(manualResult);
            }
            return manualResult;
        }
        if (TaggedScenario.isPending(tags)) {
            eventBus.testPending();
            return TestResult.PENDING;
        }
        if (TaggedScenario.isIgnored(tags)) {
            eventBus.testIgnored();
            return TestResult.IGNORED;
        }
        if (TaggedScenario.isSkippedOrWIP(tags)) {
            eventBus.testSkipped();
            return TestResult.SKIPPED;
        }
        return TestResult.SUCCESS;
    }
}

