/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.SearchForFilesOfType;
import net.thucydides.core.util.EnvironmentVariables;

public class DefaultCapabilityTypes {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = NewList.of("capability", "feature", "story");
    private static final DefaultCapabilityTypes INSTANCE = new DefaultCapabilityTypes();
    private List<String> defaultCapabilityTypes;
    private SearchForFilesOfType cucumberFileMatcher;
    SearchForFilesOfType jbehaveFileMatcher;
    private Map<String, List<String>> requirementsCache = new HashMap<String, List<String>>();

    public static DefaultCapabilityTypes instance() {
        return INSTANCE;
    }

    public void clear() {
        this.requirementsCache.clear();
        this.defaultCapabilityTypes = null;
        this.jbehaveFileMatcher = null;
        this.cucumberFileMatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRequirementTypes(EnvironmentVariables environmentVariables, Optional<Path> root) {
        if (this.requirementsCache.containsKey(this.key(environmentVariables, root))) {
            return this.requirementsCache.get(this.key(environmentVariables, root));
        }
        Map<String, List<String>> map = this.requirementsCache;
        synchronized (map) {
            List<String> requriementTypes = this.configuredRequirementTypes(environmentVariables).orElse(this.getDefaultCapabilityTypes(root));
            this.requirementsCache.put(this.key(environmentVariables, root), requriementTypes);
            return requriementTypes;
        }
    }

    public List<String> getDefaultCapabilityTypes(Optional<Path> root) {
        if (this.defaultCapabilityTypes == null) {
            this.defaultCapabilityTypes = this.jbehaveFilesExist(root) ? this.jbehaveCapabilityTypes(root) : (this.cucumberFilesExist(root) ? this.cucumberCapabilityTypes(root) : DEFAULT_CAPABILITY_TYPES);
        }
        return this.defaultCapabilityTypes;
    }

    private List<String> jbehaveCapabilityTypes(Optional<Path> root) {
        int featureDirectoryDepth = this.getJBehaveFileMatcher(root).get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("story");
            }
            case 1: {
                return NewList.of("feature", "story");
            }
        }
        return NewList.of("capability", "feature", "story");
    }

    private List<String> cucumberCapabilityTypes(Optional<Path> root) {
        int featureDirectoryDepth = this.getCucumberFileMatcher(root).get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("feature");
            }
            case 1: {
                return NewList.of("capability", "feature");
            }
        }
        return NewList.of("theme", "capability", "feature");
    }

    private Optional<SearchForFilesOfType> getJBehaveFileMatcher(Optional<Path> root) {
        if (this.jbehaveFileMatcher != null) {
            return Optional.of(this.jbehaveFileMatcher);
        }
        try {
            if (root.isPresent()) {
                this.jbehaveFileMatcher = new SearchForFilesOfType(root.get(), ".story");
                Files.walkFileTree(root.get(), this.jbehaveFileMatcher);
                return Optional.of(this.jbehaveFileMatcher);
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean jbehaveFilesExist(Optional<Path> root) {
        return this.getJBehaveFileMatcher(root).isPresent() && this.getJBehaveFileMatcher(root).get().hasMatchingFiles();
    }

    private boolean cucumberFilesExist(Optional<Path> root) {
        return this.getCucumberFileMatcher(root).isPresent() && this.getCucumberFileMatcher(root).get().hasMatchingFiles();
    }

    public int startLevelForADepthOf(Optional<Path> root, EnvironmentVariables environmentVariables, int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes(environmentVariables, root).size() - requirementsDepth);
    }

    private Optional<SearchForFilesOfType> getCucumberFileMatcher(Optional<Path> root) {
        if (this.cucumberFileMatcher != null) {
            return Optional.of(this.cucumberFileMatcher);
        }
        try {
            if (root.isPresent()) {
                this.cucumberFileMatcher = new SearchForFilesOfType(root.get(), ".feature");
                Files.walkFileTree(root.get(), this.cucumberFileMatcher);
                return Optional.of(this.cucumberFileMatcher);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<List<String>> configuredRequirementTypes(EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.isDefinedIn(environmentVariables)) {
            String configuredRequirementTypes = ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.from(environmentVariables);
            return Optional.of(Splitter.on((String)",").trimResults().splitToList((CharSequence)configuredRequirementTypes));
        }
        return Optional.empty();
    }

    private String key(EnvironmentVariables environmentVariables, Optional<Path> root) {
        return ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.optionalFrom(environmentVariables).orElse("DEFAULT") + root.orElse(Paths.get("default", new String[0]));
    }
}

