/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain.screenshots;

import java.util.Objects;
import net.thucydides.model.domain.ErrorMessageFormatter;
import net.thucydides.model.domain.stacktrace.FailureCause;
import org.apache.commons.text.StringEscapeUtils;

public class Screenshot {
    private final String filename;
    private final String description;
    private final int width;
    private final FailureCause error;
    private final Long timestamp;
    private final int depth;

    public Screenshot(String filename, String description, int width, long timestamp, FailureCause error) {
        this(filename, description, width, timestamp, error, 0);
    }

    public Screenshot(String filename, String description, int width, long timestamp, FailureCause error, int depth) {
        this.filename = filename;
        this.description = description;
        this.timestamp = timestamp;
        this.width = width;
        this.error = error;
        this.depth = depth;
    }

    public Screenshot(String filename, String description, int width, long timestamp) {
        this(filename, description, width, timestamp, null, 0);
    }

    public FailureCause getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error != null ? this.error.getMessage() : "";
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public int getDepth() {
        return this.depth;
    }

    public HtmlFormattedInfo getHtml() {
        return new HtmlFormattedInfo(this.description);
    }

    public Screenshot withDescription(String description) {
        return new Screenshot(this.filename, description, this.width, this.timestamp, this.error, this.depth);
    }

    public Screenshot withDepth(int depth) {
        return new Screenshot(this.filename, this.description, this.width, this.timestamp, this.error, depth);
    }

    public Screenshot before() {
        return new Screenshot(this.filename, this.description, this.width, this.timestamp - 1L, this.error, this.depth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Screenshot that = (Screenshot)o;
        return Objects.equals(this.filename, that.filename) && Objects.equals(this.description, that.description) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.description, this.timestamp);
    }

    public static class HtmlFormattedInfo {
        private final String description;

        HtmlFormattedInfo(String description) {
            this.description = description;
        }

        public String getDescription() {
            return StringEscapeUtils.escapeHtml4((String)this.description);
        }
    }
}

