/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.List;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.FileSystemRequirementsService;
import net.thucydides.model.requirements.Requirements;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.reports.FileSystemRequirmentsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;

public class FileSystemRequirements
implements Requirements {
    private final RequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirmentsOutcomeFactory;

    public FileSystemRequirements(String path) {
        this.requirementsService = new FileSystemRequirementsService(path);
        this.requirmentsOutcomeFactory = new FileSystemRequirmentsOutcomeFactory(ConfiguredEnvironment.getEnvironmentVariables(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()), path);
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirmentsOutcomeFactory;
    }

    @Override
    public RequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

