/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.model.domain.ExternalLink;
import net.thucydides.model.domain.Rule;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.html.TagFilter;
import net.thucydides.model.requirements.reports.ExampleOutcome;

public interface ScenarioOutcome {
    public String getName();

    public String getSimplifiedName();

    public String getTitle();

    public String getId();

    public String getType();

    public TestResult getResult();

    public String getResultStyle();

    public String getDescription();

    public List<String> getSteps();

    public List<String> getExamples();

    default public List<ExampleOutcome> getExampleOutcomes() {
        return new ArrayList<ExampleOutcome>();
    }

    public boolean hasExamples();

    public String getNumberOfExamples();

    public String getScenarioReport();

    public List<String> getScenarioReportBadges();

    public Integer getStepCount();

    public String getAllStepsText();

    public ZonedDateTime getStartTime();

    public Long getTimestamp();

    public Long getDuration();

    public Boolean isManual();

    public String getFormattedStartTime();

    public String getFormattedDuration();

    public String getParentName();

    public String getParentReport();

    public Set<TestTag> getTags();

    public Map<String, Collection<TestTag>> getExampleTags();

    public Rule getRule();

    public ExternalLink getExternalLink();

    public Collection<TestTag> getScenarioTags();

    default public boolean isBackground() {
        return "background".equalsIgnoreCase(this.getType());
    }

    default public List<TestTag> getFilteredTags() {
        TagFilter tagFilter = new TagFilter();
        return new ArrayList<TestTag>(tagFilter.removeHiddenTagsFrom(this.getTags()));
    }

    public String getContext();
}

