/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.statistics.service;

import java.util.ArrayList;
import java.util.List;
import net.thucydides.model.requirements.CoreTagProvider;
import net.thucydides.model.requirements.OverridableTagProvider;
import net.thucydides.model.statistics.service.TagProvider;

public class TagProviderFilter<T extends TagProvider> {
    public List<T> removeOverriddenProviders(List<T> providers) {
        if (this.additionalTagProvidersArePresentIn(providers)) {
            return this.removeOverridableProvidersFrom(providers);
        }
        return providers;
    }

    private boolean additionalTagProvidersArePresentIn(List<T> providers) {
        for (TagProvider provider : providers) {
            if (CoreTagProvider.class.isAssignableFrom(provider.getClass())) continue;
            return true;
        }
        return false;
    }

    private List<T> removeOverridableProvidersFrom(List<T> providers) {
        ArrayList<TagProvider> retainedProviders = new ArrayList<TagProvider>();
        for (TagProvider provider : providers) {
            if (OverridableTagProvider.class.isAssignableFrom(provider.getClass())) continue;
            retainedProviders.add(provider);
        }
        return retainedProviders;
    }
}

